/*
 * Decompiled with CFR 0.152.
 */
package org.bgerp.app.servlet.file;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.bgerp.app.servlet.file.Highlighter;
import org.bgerp.app.servlet.file.Order;

public class Options {
    private Order order;
    private boolean deletionEnabled;
    private boolean downloadEnabled;
    private final List<Highlighter> highlighters = new ArrayList<Highlighter>();

    public Options withOrder(Order value) {
        this.order = value;
        return this;
    }

    public Options withDownloadEnabled() {
        this.downloadEnabled = true;
        return this;
    }

    public Options withDeletionEnabled() {
        this.deletionEnabled = true;
        return this;
    }

    public Options withHighlighter(Highlighter ... highlighter) {
        this.highlighters.addAll(List.of(highlighter));
        return this;
    }

    public Order getOrder() {
        return this.order;
    }

    public boolean isDownloadEnabled() {
        return this.downloadEnabled;
    }

    public boolean isDeletionEnabled() {
        return this.deletionEnabled;
    }

    public Highlighter highlighter(File file) {
        return this.highlighters.stream().filter(hl -> hl.match(file)).findFirst().orElse(null);
    }
}

