/*
 * Decompiled with CFR 0.152.
 */
package org.bgerp.app.l10n;

import com.google.common.annotations.VisibleForTesting;
import java.util.List;
import java.util.Map;
import org.bgerp.app.l10n.Localization;
import org.bgerp.app.l10n.TransparentLocalizer;
import org.bgerp.util.Log;

public class Localizer {
    private static final Log log = Log.getLog();
    public static final Localizer TRANSPARENT = new TransparentLocalizer();
    private final Localization[] localizations;
    private final String lang;

    @VisibleForTesting
    public Localizer(String lang, Localization ... localizations) {
        this.lang = lang;
        this.localizations = localizations;
    }

    public String getLang() {
        return this.lang;
    }

    public String l(String pattern, Object ... args) {
        for (Localization localization : this.localizations) {
            if (localization == null) break;
            String translation = localization.getTranslation(this.lang, pattern);
            if (translation == null) continue;
            return Log.format(translation, args);
        }
        log.warn("Missing translation for pattern: '{}', localizations: {}", pattern, List.of(this.localizations));
        return Log.format(pattern, args);
    }

    public Map.Entry<String, String> entry(String key) {
        return Map.entry(key, this.l(key, new Object[0]));
    }
}

