/*
 * Decompiled with CFR 0.152.
 */
package org.bgerp.action.base;

import com.fasterxml.jackson.core.JsonGenerationException;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.reflect.InvocationTargetException;
import java.nio.charset.StandardCharsets;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Date;
import java.util.Map;
import java.util.TimeZone;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Consumer;
import javassist.NotFoundException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.actions.DispatchAction;
import org.bgerp.action.LoginAction;
import org.bgerp.action.util.Invoker;
import org.bgerp.app.cfg.ConfigMap;
import org.bgerp.app.cfg.Preferences;
import org.bgerp.app.cfg.Setup;
import org.bgerp.app.dist.lic.AppLicense;
import org.bgerp.app.event.EventProcessor;
import org.bgerp.app.exception.BGIllegalArgumentException;
import org.bgerp.app.exception.BGMessageException;
import org.bgerp.app.l10n.Localizer;
import org.bgerp.app.servlet.filter.AuthFilter;
import org.bgerp.app.servlet.user.LoginStat;
import org.bgerp.app.servlet.user.event.ActionRequestEvent;
import org.bgerp.cache.UserCache;
import org.bgerp.util.Log;
import org.bgerp.util.log.SessionLogAppender;
import ru.bgcrm.dao.Locker;
import ru.bgcrm.dao.user.UserDAO;
import ru.bgcrm.model.LastModify;
import ru.bgcrm.model.Lock;
import ru.bgcrm.model.user.PermissionNode;
import ru.bgcrm.model.user.User;
import ru.bgcrm.struts.action.PoolAction;
import ru.bgcrm.struts.form.DynActionForm;
import ru.bgcrm.util.TimeUtils;
import ru.bgcrm.util.Utils;
import ru.bgcrm.util.sql.ConnectionSet;
import ru.bgcrm.util.sql.SingleConnectionSet;

public abstract class BaseAction
extends DispatchAction {
    public static final ObjectMapper MAPPER = new ObjectMapper();
    protected static final String PATH_JSP = "/WEB-INF/jspf";
    public static final String PATH_JSP_ADMIN = "/WEB-INF/jspf/admin";
    public static final String PATH_JSP_USER = "/WEB-INF/jspf/user";
    public static final String PATH_JSP_USERMOB = "/WEB-INF/jspf/usermob";
    public static final String PATH_JSP_OPEN = "/WEB-INF/jspf/open";
    protected final Log log = Log.getLog(((Object)((Object)this)).getClass());
    protected final Setup setup = Setup.getSetup();
    private final Map<String, Invoker> invokerMap = new ConcurrentHashMap<String, Invoker>();
    protected Localizer l;

    protected BaseAction() {
    }

    public ActionForward unspecified(DynActionForm form, ConnectionSet conSet) throws Exception {
        throw new UnsupportedOperationException();
    }

    public ActionForward unspecified(DynActionForm form, Connection con) throws Exception {
        throw new UnsupportedOperationException();
    }

    protected String getParameter(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        if (request.getParameter("method") != null) {
            return "method";
        }
        String value = request.getParameter("action");
        if (value != null) {
            this.log.warnd("Deprecated action method parameter '{}' was used. Use '{}' instead. Value: {}", "action", "method", value);
        }
        return "action";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ActionForward dispatchMethod(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response, String name) throws Exception {
        DynActionForm form = (DynActionForm)actionForm;
        form.setHttpRequest(request);
        form.setHttpResponse(response);
        User user = AuthFilter.getUser(request);
        form.setUser(user);
        form.l = this.l = (Localizer)request.getAttribute("l");
        request.setAttribute("frd", form.getResponse().getData());
        ConnectionSet conSet = new ConnectionSet(this.setup.getConnectionPool(), false);
        form.setConnectionSet(conSet);
        SessionLogAppender.track(request.getSession(), false);
        long timeStart = System.currentTimeMillis();
        ActionForward forward = null;
        String action = "";
        PermissionNode permissionNode = null;
        String error = "";
        try {
            AppLicense.instance().check(form);
            if (user == null) {
                form.setPermission(ConfigMap.EMPTY);
            } else {
                action = form.action(((Object)((Object)this)).getClass());
                permissionNode = this.permissionCheck(form, action);
                this.updateUserPageSettings(conSet, form);
            }
            String requestURI = request.getRequestURI();
            String includeServletPath = (String)request.getAttribute("javax.servlet.include.servlet_path");
            if (includeServletPath != null) {
                form.requestUrl(includeServletPath, (String)request.getAttribute("javax.servlet.include.query_string"));
            } else {
                form.requestUrl(requestURI, request.getQueryString());
            }
            try {
                name = Utils.maskEmpty(name, "unspecified");
                forward = (ActionForward)this.getInvoker(name).invoke(this, mapping, form, request, response, conSet);
            }
            catch (InvocationTargetException e) {
                throw e.getCause();
            }
            conSet.commit();
            String lockId = form.getParam("lockFree");
            if (Utils.notBlankString(lockId)) {
                Locker.freeLock(new Lock(lockId, form.getUserId()));
            }
            if (!(this instanceof PoolAction) && !(this instanceof LoginAction)) {
                LoginStat.instance().actionWasCalled(request.getSession());
            }
        }
        catch (BGMessageException ex) {
            error = ex.getMessage(this.l);
            if (ex instanceof BGIllegalArgumentException) {
                form.setResponseData("paramName", ((BGIllegalArgumentException)ex).getName());
            }
            ActionForward includeServletPath = this.sendError(form, error);
            return includeServletPath;
        }
        catch (Throwable ex) {
            error = ex.getMessage();
            this.log.error(error, ex);
            StringWriter sw = new StringWriter();
            ex.printStackTrace(new PrintWriter(sw));
            ActionForward actionForward = this.sendError(form, sw.toString());
            return actionForward;
        }
        finally {
            conSet.close();
            if (Utils.notBlankString(action)) {
                EventProcessor.processEvent(new ActionRequestEvent(request, action, permissionNode, System.currentTimeMillis() - timeStart, error), null);
            }
        }
        return forward;
    }

    private Invoker getInvoker(String method) throws NoSuchMethodException {
        this.log.trace("Looking for invoker: {}", method);
        Invoker result = this.invokerMap.get(method);
        if (result == null) {
            result = Invoker.find(this.clazz, method);
            this.invokerMap.putIfAbsent(method, result);
        } else {
            this.log.trace("Cache hit", new Object[0]);
        }
        this.log.trace("Found invoker: {}", result.getClass().getSimpleName());
        return result;
    }

    protected PermissionNode permissionCheck(DynActionForm form, String action) throws NotFoundException, BGMessageException {
        PermissionNode permissionNode = PermissionNode.getPermissionNodeOrThrow(action);
        ConfigMap perm = UserCache.getPerm(form.getUserId(), action);
        if (perm == null && !permissionNode.isAllowAll()) {
            throw new BGMessageException("Action '{}' is denied.", permissionNode.getTitlePath());
        }
        form.setPermission(perm);
        return permissionNode;
    }

    private void updateUserPageSettings(ConnectionSet conSet, DynActionForm form) throws SQLException {
        String pageableId = form.getPageableId();
        int pageSize = form.getPage().getPageSize();
        if (Utils.notBlankString(pageableId) && pageSize > 0) {
            String key = "pageSize." + pageableId;
            User user = form.getUser();
            int currentValue = user.getPers().getInt(key, -1);
            if (currentValue != pageSize) {
                user.getPers().put(key, String.valueOf(pageSize));
                new UserDAO(conSet.getConnection()).updatePersonalization(null, user);
            }
        }
    }

    private ActionForward sendError(DynActionForm form, String errorText) throws IOException, JsonGenerationException, JsonMappingException {
        String responseType = form.getResponseType();
        if ("json".equalsIgnoreCase(responseType)) {
            form.getResponse().setStatus("error");
            form.getResponse().setMessage(errorText);
            return this.json((ConnectionSet)null, form);
        }
        HttpServletResponse response = form.getHttpResponse();
        response.setContentType("text/plain; charset=" + StandardCharsets.UTF_8.name());
        response.setStatus(500);
        PrintWriter out = form.getHttpResponseWriter();
        out.write(errorText);
        out.close();
        return null;
    }

    protected ActionForward html(Connection con, DynActionForm form, String path) {
        String forwardFile;
        String string = forwardFile = form != null ? form.getForwardFile() : null;
        if (Utils.notBlankString(forwardFile)) {
            path = forwardFile;
        }
        return this.html(new SingleConnectionSet(con), form, path);
    }

    protected ActionForward html(ConnectionSet conSet, DynActionForm form, String path) {
        if (form != null && "json".equalsIgnoreCase(form.getResponseType())) {
            if (AuthFilter.getUser(form.getHttpRequest()) == null) {
                throw new IllegalArgumentException("For open interface JSON response isn't allowed");
            }
            return this.json(conSet, form);
        }
        return new ActionForward(path);
    }

    protected ActionForward json(Connection con, DynActionForm form) {
        return this.json(new SingleConnectionSet(con), form);
    }

    protected ActionForward json(ConnectionSet conSet, DynActionForm form) {
        try {
            if (Utils.notBlankString(form.getForwardFile())) {
                return new ActionForward(form.getForwardFile());
            }
            if (conSet != null) {
                conSet.commit();
            }
            HttpServletResponse response = form.getHttpResponse();
            response.setContentType("application/json; charset=" + StandardCharsets.UTF_8.name());
            PrintWriter out = form.getHttpResponseWriter();
            String callback = form.getParam("callback");
            if (!Utils.isEmptyString(callback)) {
                out.write(callback + "(");
            }
            ObjectWriter objectWriter = MAPPER.writer();
            out.write(objectWriter.writeValueAsString((Object)form.getResponse()));
            if (!Utils.isEmptyString(callback)) {
                out.write(");");
            }
            out.close();
        }
        catch (Exception e) {
            this.log.error(e);
        }
        return null;
    }

    protected void checkModified(LastModify lastModify, DynActionForm form) throws BGMessageException {
        if (lastModify.getTime() != null) {
            int lastModifyUserId = Utils.parseInt(form.getParam("lastModifyUserId"), 0);
            Date lastModifyTime = TimeUtils.parse(form.getParam("lastModifyTime"), "yyyy-MM-dd HH:mm:ss");
            if (lastModify.getTime().getTime() != lastModifyTime.getTime() || lastModify.getUserId() != lastModifyUserId) {
                throw new BGMessageException("\u041e\u0431\u044a\u0435\u043a\u0442 \u0431\u044b\u043b \u0438\u0437\u043c\u0435\u043d\u0435\u043d \u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u0442\u0435\u043b\u0435\u043c \"{}\" {}", UserCache.getUser(form.getUserId()).getTitle(), TimeUtils.format(lastModify.getTime(), "ymdhms"));
            }
        }
        lastModify.setUserId(form.getUserId());
        lastModify.setTime(new Date());
    }

    protected void restoreRequestParams(Connection con, DynActionForm form, boolean get, boolean set, String ... params) throws SQLException {
        Preferences map = form.getUser().getPers();
        String mapDataBefore = map.getDataString();
        for (String param : params) {
            Object values;
            String key = "param." + form.getAreaId() + "." + param;
            if (form.getParam().getArray(param) == null) {
                if (!get || !map.containsKey(key) || (values = Utils.toList(map.get(key))).isEmpty()) continue;
                if (values.size() > 1) {
                    form.getParam().putArray(param, values.toArray(new String[0]));
                } else if (values.size() == 1) {
                    form.setParam(param, (String)values.get(0));
                }
                this.log.debug("Restoring param: {}, key: {}", param, key);
                continue;
            }
            if (!set) continue;
            values = Utils.toString(form.getParamValuesListStr(param));
            if (Utils.notBlankString((String)values)) {
                map.put(key, (String)values);
                this.log.debug("Storing param: {}, key: {}", param, key);
                continue;
            }
            map.remove(key);
            this.log.debug("Removing key: {}", key);
        }
        new UserDAO(con).updatePersonalization(mapDataBefore, form.getUser());
    }

    protected void updatePersonalization(DynActionForm form, Connection con, Consumer<Preferences> setFunction) throws Exception {
        User user = form.getUser();
        Preferences map = user.getPers();
        String mapDataBefore = map.getDataString();
        setFunction.accept(map);
        new UserDAO(con).updatePersonalization(mapDataBefore, user);
    }

    static {
        MAPPER.setTimeZone(TimeZone.getDefault());
    }
}

