<%@ page contentType="text/html; charset=UTF-8"%>
<%@ include file="/WEB-INF/jspf/taglibs.jsp"%>

<%--
Incoming variables:
	treeRootNode or frd.treeRootNode
	multiple or form.param.multiple
	itemId or form.param.itemId
	itemTitle or form.param.itemTitle
	itemCount or form.param.itemCount
--%>

<c:set var="treeRootNode" value="${not empty treeRootNode ? treeRootNode : frd.treeRootNode}"/>
<c:set var="rowItemId" value="${not empty itemId ? itemId : form.param.itemId}"/>
<c:set var="rowItemTitle" value="${not empty itemTitle ? itemTitle : form.param.itemTitle}"/>
<c:set var="rowItemCount" value="${not empty itemCount ? itemCount : form.param.itemCount}"/>

<tr>
	<td>
		<a href="#" onclick="$$.param.treecount.treeOpen(this); return false;"><c:out value="${rowItemTitle}" default="undefined"/></a>
		<div style="display: none;">
			<ui:tree-single rootNode="${treeRootNode}" name="itemId" nameTitle="itemTitle" value="${rowItemId}"
				style="height: 20em; overflow: auto;"/>
			<ui:button type="ok" styleClass="mt1 btn-white" onclick="$$.param.treecount.treeClose(this, 'itemTitle'); return false;"/>
		</div>
	</td>
	<td>
		<input type="text" name="itemCount" value="${rowItemCount}" size="4"
			onkeydown="return isNumberKey(event)" title="${l.l('Use dot as a decimal separator')}"/>
	</td>
	<td>
		<button type="button" class="btn-white btn-small icon" onclick="$$.param.treecount.delValue(this, ${not empty multiple ? multiple : form.param.multiple})"><i class='ti-trash'></i></button>
	</td>
</tr>