/*
 * Decompiled with CFR 0.152.
 */
package org.bgerp.model.msg.config;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.bgerp.app.cfg.Config;
import org.bgerp.app.cfg.ConfigMap;
import org.bgerp.model.base.Id;
import org.bgerp.model.base.IdTitle;
import org.bgerp.util.Dynamic;

@Dynamic
public class TagConfig
extends Config {
    private final List<Tag> tagList = new ArrayList<Tag>(10);
    private final Map<Integer, Tag> tagMap;

    protected TagConfig(ConfigMap config) {
        super(null);
        for (Map.Entry<Integer, ConfigMap> me : config.subIndexed("tag.").entrySet()) {
            this.tagList.add(new Tag((int)me.getKey(), me.getValue()));
        }
        this.tagMap = this.tagList.stream().collect(Collectors.toMap(Id::getId, t -> t));
    }

    public List<Tag> getTagList() {
        return this.tagList;
    }

    public Map<Integer, Tag> getTagMap() {
        return this.tagMap;
    }

    public int getSelectedHistoryTag(Collection<Integer> messageTagIds) {
        return messageTagIds.stream().filter(tagId -> tagId == -2 || tagId == -3).findFirst().orElse(0);
    }

    public static final class Tag
    extends IdTitle {
        private final String color;
        @Dynamic
        public static final int TAG_ATTACH_ID = -1;
        @Dynamic
        public static final int TAG_UNREAD_ID = -5;
        @Dynamic
        public static final int TAG_HISTORY_WITH_ADDRESS_ID = -2;
        @Dynamic
        public static final int TAG_HISTORY_ALL_ID = -3;
        @Dynamic
        public static final int TAG_PIN_ID = -4;

        private Tag(int id, ConfigMap config) {
            super(id, config.get("title", "???"));
            this.color = config.get("color", "ff0000");
        }

        public String getColor() {
            return this.color;
        }
    }
}

