/*
 * Decompiled with CFR 0.152.
 */
package org.bgerp.app.servlet.file;

import com.google.common.collect.Lists;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.filefilter.WildcardFileFilter;
import org.apache.struts.action.ActionForward;
import org.bgerp.action.base.Actions;
import org.bgerp.action.base.BaseAction;
import org.bgerp.app.exception.BGIllegalArgumentException;
import org.bgerp.app.servlet.file.Highlighter;
import org.bgerp.app.servlet.file.Options;
import ru.bgcrm.struts.form.DynActionForm;
import ru.bgcrm.util.Utils;

public class Files {
    private final Class<? extends BaseAction> actionClass;
    private final Path basedir;
    private final String id;
    private final Options options;
    private final FileFilter fileFilter;

    public Files(Class<? extends BaseAction> actionClass, String id, String basedir, Options options, String ... wildcards) {
        this.actionClass = actionClass;
        this.id = id;
        this.basedir = Paths.get(basedir, new String[0]);
        this.options = options;
        this.fileFilter = WildcardFileFilter.builder().setWildcards(wildcards).get();
    }

    public String getId() {
        return this.id;
    }

    public Options getOptions() {
        return this.options;
    }

    public String getDownloadPermissionAction() {
        return Actions.getByClass(this.actionClass).getId() + ":" + this.getActionMethod("download");
    }

    public String getDownloadURL() {
        return Actions.getByClass(this.actionClass).getPath() + ".do?method=" + this.getActionMethod("download");
    }

    public String getHighlightPermissionAction() {
        return Actions.getByClass(this.actionClass).getId() + ":" + this.getActionMethod("highlight");
    }

    public String getHighlightURL() {
        return Actions.getByClass(this.actionClass).getPath() + ".do?method=" + this.getActionMethod("highlight");
    }

    public String getDeletePermissionAction() {
        return Actions.getByClass(this.actionClass).getId() + ":" + this.getActionMethod("delete");
    }

    public String getDeleteURL() {
        return Actions.getByClass(this.actionClass).getPath() + ".do?method=" + this.getActionMethod("delete");
    }

    private String getActionMethod(String prefix) {
        return prefix + this.id.substring(0, 1).toUpperCase() + this.id.substring(1);
    }

    public List<File> list() {
        ArrayList result;
        File basedir = this.basedir.toFile();
        ArrayList arrayList = result = basedir.isDirectory() ? Lists.newArrayList((Object[])basedir.listFiles(this.fileFilter)) : new ArrayList();
        if (this.options.getOrder() != null) {
            result.sort(this.options.getOrder());
        }
        return result;
    }

    public long size(List<File> files) {
        return files.stream().mapToLong(File::length).sum();
    }

    public ActionForward download(DynActionForm form) throws BGIllegalArgumentException, IOException, FileNotFoundException {
        String name = form.getParam("name", Utils::notBlankString);
        HttpServletResponse response = form.getHttpResponse();
        Utils.setFileNameHeaders(response, name);
        IOUtils.copy((InputStream)new FileInputStream(new File(this.basedir.toFile(), name)), (OutputStream)response.getOutputStream());
        return null;
    }

    public DynActionForm highlight(DynActionForm form) throws BGIllegalArgumentException, FileNotFoundException {
        String className;
        String name = form.getParam("name", Utils::notBlankString);
        File file = new File(this.basedir.toFile(), name);
        Highlighter highlighter = this.options.highlighter(file);
        if (highlighter != null && Utils.notBlankString(className = highlighter.highlight(file))) {
            form.setResponseData("classes", List.of(className));
        }
        return form;
    }

    public DynActionForm delete(DynActionForm form) {
        for (String name : form.getParamValuesStr("name")) {
            FileUtils.deleteQuietly((File)new File(this.basedir.toFile(), name));
        }
        return form;
    }
}

