/*
 * Decompiled with CFR 0.152.
 */
package ru.bgcrm.model.process;

import java.util.HashSet;
import java.util.Set;
import org.bgerp.model.process.ProcessGroups;
import ru.bgcrm.util.Utils;

public class ProcessGroup
implements Comparable<ProcessGroup> {
    protected int groupId;
    protected int roleId;

    public ProcessGroup() {
    }

    public ProcessGroup(int groupId) {
        this(groupId, 0);
    }

    public ProcessGroup(int groupId, int roleId) {
        if (groupId < 0) {
            groupId = 0;
        }
        if (roleId < 0) {
            roleId = 0;
        }
        this.groupId = groupId;
        this.roleId = roleId;
    }

    public int getRoleId() {
        return this.roleId;
    }

    public void setRoleId(int roleId) {
        this.roleId = roleId;
    }

    public int getGroupId() {
        return this.groupId;
    }

    public void setGroupId(int groupId) {
        this.groupId = groupId;
    }

    public String toGroupRolePair() {
        return this.groupId + ":" + this.roleId;
    }

    public boolean checkGroupAndRole(int groupId, int roleId) {
        return this.groupId == groupId && this.roleId == roleId;
    }

    public ProcessGroup createProcessGroup() {
        return new ProcessGroup(this.groupId, this.roleId);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.groupId;
        result = 31 * result + this.roleId;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ProcessGroup other = (ProcessGroup)obj;
        if (this.groupId != other.groupId) {
            return false;
        }
        return this.roleId == other.roleId;
    }

    @Override
    public int compareTo(ProcessGroup o) {
        return this.hashCode() - o.hashCode();
    }

    public static final String serialize(Set<ProcessGroup> processGroups) {
        StringBuilder roleGroup = new StringBuilder(20);
        for (ProcessGroup item : processGroups) {
            Utils.addCommaSeparated(roleGroup, String.valueOf(item.getGroupId()));
            if (item.getRoleId() <= 0) continue;
            roleGroup.append(":");
            roleGroup.append(item.getRoleId());
        }
        return roleGroup.toString();
    }

    public static final Set<Integer> toGroupSet(Set<ProcessGroup> processGroups) {
        HashSet<Integer> resultSet = new HashSet<Integer>();
        for (ProcessGroup processGroup : processGroups) {
            resultSet.add(processGroup.getGroupId());
        }
        return resultSet;
    }

    public static ProcessGroups toProcessGroupSet(Set<Integer> set, int roleId) {
        ProcessGroups resultSet = new ProcessGroups();
        for (Integer item : set) {
            resultSet.add(new ProcessGroup(item, roleId));
        }
        return resultSet;
    }

    public static Set<ProcessGroup> parseFromStringSet(Set<String> values) {
        HashSet<ProcessGroup> resultSet = new HashSet<ProcessGroup>();
        for (String value : values) {
            if (value.indexOf(":") > -1) {
                resultSet.add(new ProcessGroup(Utils.parseInt(value.substring(0, value.indexOf(":"))), Utils.parseInt(value.substring(value.indexOf(":") + 1))));
                continue;
            }
            resultSet.add(new ProcessGroup(Utils.parseInt(value), 0));
        }
        return resultSet;
    }

    public static Set<Integer> getGroupsWithRole(Set<ProcessGroup> processGroupSet, int role) {
        HashSet<Integer> result = new HashSet<Integer>();
        for (ProcessGroup value : processGroupSet) {
            if (value.getRoleId() != role) continue;
            result.add(value.getGroupId());
        }
        return result;
    }

    public static boolean isGroupWithRoleExist(Set<ProcessGroup> processGroupSet, int group, int role) {
        for (ProcessGroup value : processGroupSet) {
            if (value.getGroupId() != group || value.getRoleId() != role) continue;
            return true;
        }
        return false;
    }
}

