/*
 * Decompiled with CFR 0.152.
 */
package ru.bgcrm.event.process;

import java.util.Set;
import org.bgerp.cache.ProcessTypeCache;
import org.bgerp.event.base.UserEvent;
import ru.bgcrm.model.process.Process;
import ru.bgcrm.model.process.ProcessExecutor;
import ru.bgcrm.model.process.ProcessGroup;
import ru.bgcrm.model.process.ProcessType;
import ru.bgcrm.model.process.StatusChange;
import ru.bgcrm.struts.form.DynActionForm;

public class ProcessChangingEvent
extends UserEvent {
    public static final int MODE_STATUS_CHANGING = 1;
    public static final int MODE_DESCRIPTION_CHANGING = 2;
    public static final int MODE_EXECUTORS_CHANGING = 3;
    public static final int MODE_PRIORITY_CHANGING = 4;
    public static final int MODE_GROUPS_CHANGING = 5;
    public static final int MODE_DESCRIPTION_ADDING = 6;
    public static final int MODE_TYPE_CHANGING = 7;
    private final Process process;
    private final int changeMode;
    private final Object value;

    public ProcessChangingEvent(DynActionForm form, Process process, Object value, int changeMode) {
        super(form);
        this.process = process;
        this.value = value;
        this.changeMode = changeMode;
    }

    public Process getProcess() {
        return this.process;
    }

    public boolean isStatus() {
        return this.changeMode == 1;
    }

    public boolean isClosing() {
        if (!this.isStatus()) {
            return false;
        }
        ProcessType type = ProcessTypeCache.getProcessType(this.process.getTypeId());
        return this.process.getCloseTime() == null && type.getProperties().getCloseStatusIds().contains(this.getStatusChange().getStatusId());
    }

    public boolean isOpening() {
        if (!this.isStatus()) {
            return false;
        }
        ProcessType type = ProcessTypeCache.getProcessType(this.process.getTypeId());
        return this.process.getCloseTime() != null && !type.getProperties().getCloseStatusIds().contains(this.getStatusChange().getStatusId());
    }

    public StatusChange getStatusChange() {
        if (!this.isStatus()) {
            return null;
        }
        return (StatusChange)this.value;
    }

    public boolean isDescription() {
        return this.changeMode == 2;
    }

    public boolean isDescriptionAdd() {
        return this.changeMode == 6;
    }

    public String getDescription() {
        if (!this.isDescription() && !this.isDescriptionAdd()) {
            return null;
        }
        return (String)this.value;
    }

    public boolean isGroups() {
        return this.changeMode == 5;
    }

    public Set<Integer> getGroups() {
        Set<ProcessGroup> processGroups = this.getProcessGroups();
        if (processGroups == null) {
            return null;
        }
        return ProcessGroup.toGroupSet(processGroups);
    }

    public Set<ProcessGroup> getProcessGroups() {
        if (!this.isGroups()) {
            return null;
        }
        return (Set)this.value;
    }

    public boolean isExecutors() {
        return this.changeMode == 3;
    }

    public Set<Integer> getExecutors() {
        Set<ProcessExecutor> processExecutors = this.getProcessExecutors();
        if (processExecutors == null) {
            return null;
        }
        return ProcessExecutor.toExecutorSet(processExecutors);
    }

    public Set<ProcessExecutor> getProcessExecutors() {
        if (!this.isExecutors()) {
            return null;
        }
        return (Set)this.value;
    }

    public boolean isPriority() {
        return this.changeMode == 4;
    }

    public Integer getPriority() {
        if (!this.isPriority()) {
            return null;
        }
        return (Integer)this.value;
    }

    public boolean isTypeId() {
        return this.changeMode == 7;
    }

    public Integer getTypeId() {
        if (!this.isTypeId()) {
            return null;
        }
        return (Integer)this.value;
    }
}

