/*
 * Decompiled with CFR 0.152.
 */
package org.bgerp.plugin.svc.dba.model;

import java.util.EnumSet;

public enum QueryType {
    SELECT("SELECT"),
    SHOW("SHOW"),
    INSERT("INSERT"),
    CREATE("CREATE"),
    UPDATE("UPDATE"),
    DELETE("DELETE"),
    ALTER("ALTER"),
    DROP("DROP"),
    CALL("CALL"),
    EXPLAIN("EXPLAIN");

    private final String prefix;

    private QueryType(String prefix) {
        this.prefix = prefix;
    }

    public String prefix() {
        return this.prefix;
    }

    public static QueryType of(String query) {
        query = query.trim().toUpperCase();
        for (QueryType q : EnumSet.allOf(QueryType.class)) {
            if (!query.startsWith(q.prefix)) continue;
            return q;
        }
        return null;
    }
}

