/*
 * Decompiled with CFR 0.152.
 */
package org.bgerp.plugin.pln.grpl;

import java.sql.Connection;
import java.time.Duration;
import java.util.List;
import java.util.Map;
import org.bgerp.app.cfg.Setup;
import org.bgerp.app.event.EventProcessor;
import org.bgerp.model.base.IdTitle;
import org.bgerp.plugin.pln.grpl.Config;
import org.bgerp.plugin.pln.grpl.dao.GrplDAO;
import org.bgerp.plugin.pln.grpl.model.BoardConfig;
import ru.bgcrm.dao.process.ProcessDAO;
import ru.bgcrm.event.ParamChangedEvent;
import ru.bgcrm.event.process.ProcessRemovedEvent;
import ru.bgcrm.model.process.Process;
import ru.bgcrm.plugin.Endpoint;

public class Plugin
extends ru.bgcrm.plugin.Plugin {
    public static final String ID = "grpl";
    public static final Plugin INSTANCE = new Plugin();
    public static final String PATH_JSP_USER = "/WEB-INF/jspf/user/plugin/grpl";

    private Plugin() {
        super(ID);
    }

    @Override
    public String getTitle() {
        return "Group Plan";
    }

    @Override
    protected Map<String, List<String>> endpoints() {
        return Map.of("js", List.of(Endpoint.getPathPluginJS(ID)), "css.jsp", List.of(Endpoint.getPathPluginCSS(ID)), "user.process.menu.items.jsp", List.of("/WEB-INF/jspf/user/plugin/grpl/menu_items.jsp"));
    }

    @Override
    public void init(Connection con) throws Exception {
        super.init(con);
        EventProcessor.subscribe((e, conSet) -> {
            Config config = this.getConfig(Setup.getSetup());
            for (BoardConfig board : config.getBoards(e.getParameter().getId())) {
                IdTitle column;
                Process process;
                if (!board.hasProcessType((process = new ProcessDAO(conSet.getConnection()).getProcessOrThrow(e.getObjectId())).getTypeId()) || (column = board.getColumn(conSet, process)) == null) continue;
                Duration duration = board.getProcessDuration(conSet, process);
                new GrplDAO(conSet.getConnection()).updateSlot(board, process, column.getId(), duration);
            }
        }, ParamChangedEvent.class);
        EventProcessor.subscribe((e, conSet) -> new GrplDAO(conSet.getConnection()).deleteProcess(e.getProcess().getId()), ProcessRemovedEvent.class);
    }

    public Config getConfig(Setup setup) {
        return setup.getConfig(Config.class);
    }
}

