/*
 * Decompiled with CFR 0.152.
 */
package org.bgerp.dao.process;

import java.sql.Connection;
import java.util.Set;
import org.apache.commons.collections4.CollectionUtils;
import org.bgerp.dao.process.Order;
import org.bgerp.util.sql.PreparedQuery;
import ru.bgcrm.dao.CommonDAO;
import ru.bgcrm.struts.form.DynActionForm;
import ru.bgcrm.util.Utils;

abstract class SearchDAO
extends CommonDAO {
    protected final DynActionForm form;
    private Boolean open;
    private Set<Integer> typeIds;
    private Set<Integer> statusIds;
    protected Set<Integer> executorIds;
    protected Set<Integer> excludeIds;
    protected String idOrDescriptionLike;
    private Order order;

    protected SearchDAO(Connection con) {
        super(con);
        this.form = null;
    }

    protected SearchDAO(Connection con, DynActionForm form) {
        super(con);
        this.form = form;
    }

    protected SearchDAO withOpen(Boolean value) {
        this.open = value;
        return this;
    }

    protected SearchDAO withType(Set<Integer> values) {
        this.typeIds = values;
        return this;
    }

    protected SearchDAO withStatus(Set<Integer> values) {
        this.statusIds = values;
        return this;
    }

    protected SearchDAO withExecutor(Set<Integer> values) {
        this.executorIds = values;
        return this;
    }

    protected SearchDAO withoutId(Set<Integer> values) {
        this.excludeIds = values;
        return this;
    }

    protected SearchDAO withIdOrDescriptionLike(String value) {
        this.idOrDescriptionLike = value;
        return this;
    }

    protected SearchDAO order(Order value) {
        this.order = value;
        return this;
    }

    protected void filterOpen(PreparedQuery pq) {
        if (this.open != null) {
            pq.addQuery(" AND p.close_dt IS ");
            if (!this.open.booleanValue()) {
                pq.addQuery("NOT ");
            }
            pq.addQuery("NULL ");
        }
    }

    protected void filterType(PreparedQuery pq) {
        if (this.typeIds != null && !this.typeIds.isEmpty()) {
            pq.addQuery(" AND p.type_id IN (").addQuery(Utils.toString(this.typeIds)).addQuery(") ");
        }
    }

    protected void filterStatus(PreparedQuery pq) {
        if (this.statusIds != null && !this.statusIds.isEmpty()) {
            pq.addQuery(" AND p.status_id IN (").addQuery(Utils.toString(this.statusIds)).addQuery(") ");
        }
    }

    protected void filterExecutor(PreparedQuery pq) {
        if (this.executorIds != null && !this.executorIds.isEmpty()) {
            pq.addQuery(" INNER JOIN  process_executor AS pe ON p.id=pe.process_id AND pe.user_id IN (").addQuery(Utils.toString(this.executorIds)).addQuery(") ");
        }
    }

    protected void filterId(PreparedQuery pq) {
        if (CollectionUtils.isNotEmpty(this.excludeIds)) {
            pq.addQuery(" AND p.id NOT IN (" + Utils.toString(this.excludeIds) + ") ");
        }
    }

    protected void filterIdOrDescriptionLike(PreparedQuery pq) {
        if (Utils.notBlankString(this.idOrDescriptionLike)) {
            pq.addQuery(" AND (p.id LIKE ? OR p.description LIKE ?)");
            pq.addString(this.idOrDescriptionLike).addString(this.idOrDescriptionLike);
        }
    }

    protected void order(PreparedQuery pq) {
        if (this.order != null) {
            pq.addQuery(" ORDER BY ").addQuery(this.order.sql("p."));
        }
    }
}

