/*
 * Decompiled with CFR 0.152.
 */
package ru.bgcrm.struts.form;

import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.time.YearMonth;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.beanutils.DynaBean;
import org.apache.commons.beanutils.DynaClass;
import org.apache.commons.beanutils.DynaProperty;
import org.apache.struts.action.ActionForm;
import org.apache.struts.upload.FormFile;
import org.bgerp.action.base.Actions;
import org.bgerp.action.base.BaseAction;
import org.bgerp.app.cfg.ConfigMap;
import org.bgerp.app.exception.BGIllegalArgumentException;
import org.bgerp.app.l10n.Localization;
import org.bgerp.app.l10n.Localizer;
import org.bgerp.app.servlet.util.ServletUtils;
import org.bgerp.util.Log;
import org.bgerp.util.TimeConvert;
import ru.bgcrm.model.Page;
import ru.bgcrm.model.user.User;
import ru.bgcrm.plugin.PluginManager;
import ru.bgcrm.struts.form.ArrayHashMap;
import ru.bgcrm.struts.form.Response;
import ru.bgcrm.util.TimeUtils;
import ru.bgcrm.util.Utils;
import ru.bgcrm.util.sql.ConnectionSet;

public class DynActionForm
extends ActionForm
implements DynaBean,
DynaClass {
    private static final Log log = Log.getLog();
    public static final String KEY = "form";
    public static final String RESPONSE_TYPE_HTML = "html";
    public static final String RESPONSE_TYPE_JSON = "json";
    public static final String RESPONSE_TYPE_STREAM = "stream";
    public static DynActionForm SYSTEM_FORM;
    @Deprecated
    public static DynActionForm SERVER_FORM;
    private static final String PARAM_PAGE = "page";
    private static final String PARAM_FILE = "file";
    public static final String PARAM_ACTION_METHOD = "method";
    public static final String PARAM_ACTION_METHOD_OLD = "action";
    private static final String PARAM_ID = "id";
    private static final String PARAM_REQUEST_URL = "requestUrl";
    private static final String PARAM_RESPONSE_TYPE = "responseType";
    private static final String PARAM_RETURN_URL = "returnUrl";
    private static final String PARAM_RETURN_CHILD_UIID = "returnChildUiid";
    private static final String PARAM_CLOSE_SCRIPT = "closeScript";
    private static final String PARAM_FORWARD_FILE = "forwardFile";
    private static final Map<String, DynaProperty> PROPERTIES;
    private static final String PARAM_OVERWRITE_NAME_PREFIX = "!";
    private HttpServletRequest httpRequest;
    private HttpServletResponse httpResponse;
    private OutputStream httpResponseOutputStream;
    private Page page = new Page();
    private FormFile file;
    private ArrayHashMap param = new ArrayHashMap();
    private ConnectionSet connectionSet;
    private User user;
    private String action = "???";
    private ConfigMap permission;
    public Localizer l;
    private Response response = new Response();

    public DynActionForm() {
    }

    public DynActionForm(User user) {
        this.setUser(user);
        this.permission = ConfigMap.EMPTY;
        if (PluginManager.getInstance() != null) {
            this.l = Localization.getLocalizer();
        }
    }

    public DynActionForm(String url) {
        int pos = url.indexOf("?");
        if (pos > 0) {
            url = url.substring(pos + 1);
        }
        String[] params = url.split("&");
        TreeMap paramsForForm = new TreeMap();
        for (String param : params) {
            pos = param.indexOf(61);
            if (pos < 0) continue;
            try {
                String key = URLDecoder.decode(param.substring(0, pos), StandardCharsets.UTF_8.name());
                boolean overwrite = key.startsWith(PARAM_OVERWRITE_NAME_PREFIX);
                if (overwrite) {
                    key = key.substring(1);
                }
                String value = URLDecoder.decode(param.substring(pos + 1), StandardCharsets.UTF_8.name());
                if (overwrite || paramsForForm.get(key) == null) {
                    ArrayList<String> arrayValues = new ArrayList<String>(1);
                    arrayValues.add(value);
                    paramsForForm.put(key, arrayValues);
                    continue;
                }
                ((List)paramsForForm.get(key)).add(value);
            }
            catch (UnsupportedEncodingException e) {
                log.error(e);
            }
        }
        this.param.putArrays(paramsForForm.entrySet().stream().collect(Collectors.toMap(me -> (String)me.getKey(), me -> ((List)me.getValue()).toArray(new String[0]))));
    }

    public String paramsToQueryString() {
        StringBuilder result = new StringBuilder(200);
        for (Map.Entry me : this.param.entrySet()) {
            String key = (String)me.getKey();
            if (PARAM_REQUEST_URL.equals(key)) continue;
            for (String value : (String[])me.getValue()) {
                if (!result.isEmpty()) {
                    result.append("&");
                }
                try {
                    result.append(key).append("=").append(URLEncoder.encode(value, StandardCharsets.UTF_8.name()));
                }
                catch (UnsupportedEncodingException e) {
                    log.error(e);
                }
            }
        }
        return result.toString();
    }

    public HttpServletRequest getHttpRequest() {
        return this.httpRequest;
    }

    public void setHttpRequest(HttpServletRequest httpRequest) {
        this.httpRequest = httpRequest;
    }

    public String getRequestURI() {
        return ServletUtils.getRequestURI(this.httpRequest);
    }

    @Deprecated
    public String getHttpRequestURI() {
        log.warndMethod("getHttpRequestURI", "getRequestURI");
        return this.getRequestURI();
    }

    public HttpServletResponse getHttpResponse() {
        return this.httpResponse;
    }

    public void setHttpResponse(HttpServletResponse httpResponse) {
        this.httpResponse = httpResponse;
    }

    public OutputStream getHttpResponseOutputStream() throws IOException {
        if (this.httpResponseOutputStream == null) {
            this.httpResponseOutputStream = this.httpResponse.getOutputStream();
        }
        return this.httpResponseOutputStream;
    }

    public PrintWriter getHttpResponseWriter() throws IOException {
        return new PrintWriter(new OutputStreamWriter(this.getHttpResponseOutputStream(), this.httpResponse.getCharacterEncoding()));
    }

    public Page getPage() {
        return this.page;
    }

    public FormFile getFile() {
        return this.file;
    }

    public ArrayHashMap getParam() {
        return this.param;
    }

    public String getMethod() {
        return this.getParam(PARAM_ACTION_METHOD);
    }

    @Deprecated
    public String getAction() {
        String value = this.getMethod();
        log.warnd("Deprecated method 'getAction' was called. Use 'getMethod' instead. Value: {}, URI: {}", value, this.getRequestURI());
        return value;
    }

    public String action(Class<? extends BaseAction> clazz) {
        this.action = Actions.getByClass(clazz).getId() + ":" + Utils.maskEmpty(this.getMethod(), "null");
        return this.action;
    }

    public int getId() {
        return this.getParamInt(PARAM_ID);
    }

    public String getRequestUrl() {
        return this.getParam(PARAM_REQUEST_URL);
    }

    public void setRequestUrl(String value) {
        this.setParam(PARAM_REQUEST_URL, value);
    }

    public void requestUrl(String path, String queryString) {
        Object requestUrl = path;
        if (Utils.notBlankString(queryString)) {
            requestUrl = (String)requestUrl + "?" + queryString;
        }
        this.setRequestUrl((String)requestUrl);
    }

    public String getResponseType() {
        return this.getParam(PARAM_RESPONSE_TYPE);
    }

    public void setResponseType(String value) {
        this.setParam(PARAM_RESPONSE_TYPE, value);
    }

    public String getReturnUrl() {
        return this.getParam(PARAM_RETURN_URL);
    }

    public String getReturnChildUiid() {
        return this.getParam(PARAM_RETURN_CHILD_UIID);
    }

    public String getCloseScript() {
        return this.getParam(PARAM_CLOSE_SCRIPT);
    }

    @Deprecated
    public String getForwardFile() {
        String result = this.getParam(PARAM_FORWARD_FILE);
        if (Utils.notBlankString(result)) {
            log.warn("Used request parameter forwardFile={}", result);
        }
        return result;
    }

    @Deprecated
    public void setForwardFile(String value) {
        this.setParam(PARAM_FORWARD_FILE, value);
    }

    public String getPageableId() {
        return this.getParam("pageableId", this.action);
    }

    public String getAreaId() {
        return this.getParam("areaId", this.action);
    }

    public String getParam(String name, String defaultValue, boolean defaultSet, Predicate<String> validator) throws BGIllegalArgumentException {
        String value = this.getParam(name);
        if (validator != null && !validator.test(value)) {
            throw new BGIllegalArgumentException(name);
        }
        if (value != null) {
            return value;
        }
        if (defaultSet) {
            this.setParam(name, defaultValue);
        }
        return defaultValue;
    }

    public String getParam(String name, String defaultValue, Predicate<String> validator) throws BGIllegalArgumentException {
        return this.getParam(name, defaultValue, false, validator);
    }

    public String getParam(String name, String defaultValue) {
        String value = this.getParam(name);
        return value == null ? defaultValue : value;
    }

    public String getParam(String name, Predicate<String> validator) throws BGIllegalArgumentException {
        return this.getParam(name, null, validator);
    }

    public String getParam(String name) {
        String value = this.param.get(name);
        if (PARAM_ACTION_METHOD_OLD.equals(name)) {
            log.warnd("Deprecated request parameter '{}' was gotten. Use '{}' instead. Value: {}", PARAM_ACTION_METHOD_OLD, PARAM_ACTION_METHOD, value);
        }
        return value;
    }

    public void setParam(String name, String value) {
        if (PARAM_ACTION_METHOD_OLD.equals(name)) {
            this.param.put(PARAM_ACTION_METHOD, value);
            log.warnd("Deprecated request parameter '{}' was set. Use '{}' instead. Value: {}", PARAM_ACTION_METHOD_OLD, PARAM_ACTION_METHOD, value);
        }
        this.param.put(name, value);
    }

    public Date getParamDate(String name, Date defaultValue, boolean defaultSet) {
        Date value = TimeUtils.parse(this.getParam(name), "ymd");
        if (value != null) {
            return value;
        }
        if (defaultSet) {
            this.setParam(name, TimeUtils.format(defaultValue, "ymd"));
        }
        return defaultValue;
    }

    public Date getParamDate(String name, Date defaultValue) {
        return this.getParamDate(name, defaultValue, false);
    }

    public Date getParamDate(String name) {
        return this.getParamDate(name, null);
    }

    public YearMonth getParamYearMonth(String name, Predicate<YearMonth> validator) throws BGIllegalArgumentException {
        YearMonth result = TimeConvert.toYearMonth(this.getParamDate(name));
        if (validator != null && !validator.test(result)) {
            throw new BGIllegalArgumentException(name);
        }
        return result;
    }

    public Date getParamDateTime(String name, String format, Date defaultValue) {
        Date value = TimeUtils.parse(this.getParam(name), format);
        return value != null ? value : defaultValue;
    }

    public Date getParamDateTime(String name, String format) {
        return this.getParamDateTime(name, format, (Date)null);
    }

    public Date getParamDateTime(String name, String format, Predicate<Date> validator) throws BGIllegalArgumentException {
        Date result = this.getParamDateTime(name, format);
        if (validator != null && !validator.test(result)) {
            throw new BGIllegalArgumentException(name);
        }
        return result;
    }

    @Deprecated
    public Date getParamDateTime(String name) {
        log.warndMethod("getParamDateTime(String)");
        return this.getParamDateTime(name, "ymdhms", (Date)null);
    }

    public int getParamInt(String name, int defaultValue) {
        return Utils.parseInt(this.getParam(name), defaultValue);
    }

    public int getParamInt(String name) {
        return this.getParamInt(name, 0);
    }

    public int getParamInt(String name, Predicate<Integer> validator) throws BGIllegalArgumentException {
        String value = this.getParam(name);
        Integer result = Utils.isBlankString(value) ? 0 : Utils.parseInt(value);
        if (validator != null && !validator.test(result)) {
            throw new BGIllegalArgumentException(name);
        }
        return result;
    }

    public long getParamLong(String name, long defaultValue) {
        return Utils.parseLong(this.getParam(name), defaultValue);
    }

    public long getParamLong(String name) {
        return this.getParamLong(name, 0L);
    }

    public Boolean getParamBoolean(String name, Boolean defaultValue) {
        return Utils.parseBoolean(this.getParam(name), defaultValue);
    }

    public boolean getParamBoolean(String name) {
        return this.getParamBoolean(name, false);
    }

    public Set<Integer> getParamValues(String name) {
        HashSet<Integer> result = new HashSet<Integer>();
        String[] array = this.param.getArray(name);
        if (array != null) {
            for (String value : array) {
                try {
                    result.add(Integer.parseInt(value.trim()));
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        return result;
    }

    public Set<String> getParamValuesStr(String name) {
        String[] array = this.param.getArray(name);
        if (array != null) {
            return Stream.of(array).filter(Utils::notBlankString).collect(Collectors.toSet());
        }
        return Collections.emptySet();
    }

    public List<Integer> getParamValuesList(String name) {
        ArrayList<Integer> result = new ArrayList<Integer>();
        String[] array = this.param.getArray(name);
        if (array != null) {
            for (String value : array) {
                int valInt = Utils.parseInt(value);
                if (valInt == 0) continue;
                result.add(valInt);
            }
        }
        return result;
    }

    public List<String> getParamValuesListStr(String name) {
        return this.getParamValuesListStr(name, null);
    }

    public List<String> getParamValuesListStr(String name, String exclude) {
        ArrayList<String> result = new ArrayList<String>();
        String[] array = this.param.getArray(name);
        if (array != null) {
            for (String value : array) {
                if (exclude != null && exclude.equals(value)) continue;
                result.add(value);
            }
        }
        return result;
    }

    public ConnectionSet getConnectionSet() {
        return this.connectionSet;
    }

    public void setConnectionSet(ConnectionSet value) {
        this.connectionSet = value;
    }

    public User getUser() {
        return this.user;
    }

    public void setUser(User user) {
        this.user = user;
        if (user != null) {
            this.param.setLogTrackingId("UID: " + user.getId());
        }
    }

    public int getUserId() {
        return this.user != null ? this.user.getId() : -1;
    }

    public ConfigMap getPermission() {
        return this.permission;
    }

    public void setPermission(ConfigMap permission) {
        this.permission = permission;
    }

    public Response getResponse() {
        return this.response;
    }

    public void setResponseData(String key, Object value) {
        this.response.setData(key, value);
    }

    public void setRequestAttribute(String key, Object value) {
        this.httpRequest.setAttribute(key, value);
    }

    public Object get(String name) {
        if (PARAM_PAGE.equals(name)) {
            return this.page;
        }
        if (PARAM_FILE.equals(name)) {
            return this.file;
        }
        if ("response".equals(name)) {
            return this.response;
        }
        return this.getParam(name);
    }

    public void set(String name, Object value) {
        Class type = this.getDynaProperty(name).getType();
        if (type == String.class) {
            this.setParam(name, (String)value);
        } else if (type == FormFile.class) {
            this.file = (FormFile)value;
        } else {
            String[] values = (String[])value;
            if (name.startsWith(PARAM_OVERWRITE_NAME_PREFIX)) {
                this.setParam(name.substring(1), values[values.length - 1]);
            } else {
                this.param.putArray(name, values);
            }
        }
    }

    public boolean contains(String name, String key) {
        throw new UnsupportedOperationException();
    }

    public Object get(String name, int index) {
        throw new UnsupportedOperationException();
    }

    public Object get(String name, String key) {
        throw new UnsupportedOperationException();
    }

    public DynaClass getDynaClass() {
        return this;
    }

    public void remove(String name, String key) {
        throw new UnsupportedOperationException();
    }

    public void set(String name, int index, Object value) {
        throw new UnsupportedOperationException();
    }

    public void set(String name, String key, Object value) {
        throw new UnsupportedOperationException();
    }

    public String getName() {
        throw new UnsupportedOperationException();
    }

    public DynaProperty getDynaProperty(String name) {
        DynaProperty result = PROPERTIES.get(name);
        if (result == null) {
            result = new DynaProperty(name, String[].class);
        }
        return result;
    }

    public DynaProperty[] getDynaProperties() {
        throw new UnsupportedOperationException();
    }

    public DynaBean newInstance() throws IllegalAccessException, InstantiationException {
        return new DynActionForm();
    }

    static {
        SERVER_FORM = SYSTEM_FORM = new DynActionForm(User.USER_SYSTEM);
        PROPERTIES = new HashMap<String, DynaProperty>();
        PROPERTIES.put(PARAM_PAGE, new DynaProperty(PARAM_PAGE, Page.class));
        PROPERTIES.put(PARAM_FILE, new DynaProperty(PARAM_FILE, FormFile.class));
        for (String name : List.of(PARAM_ACTION_METHOD, PARAM_ACTION_METHOD_OLD, PARAM_ID, PARAM_REQUEST_URL, PARAM_RESPONSE_TYPE, PARAM_RETURN_URL, PARAM_RETURN_CHILD_UIID, PARAM_CLOSE_SCRIPT, PARAM_FORWARD_FILE)) {
            PROPERTIES.put(name, new DynaProperty(name, String.class));
        }
    }
}

