/*
 * Decompiled with CFR 0.152.
 */
package org.bgerp.plugin.telegram;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.bgerp.app.cfg.Setup;
import org.bgerp.app.exception.BGException;
import org.bgerp.cache.UserCache;
import org.bgerp.dao.param.ParamValueDAO;
import org.bgerp.model.base.Id;
import org.bgerp.plugin.telegram.Bot;
import org.bgerp.plugin.telegram.Config;
import org.bgerp.util.Log;
import ru.bgcrm.model.process.Process;
import ru.bgcrm.util.Utils;

public class ExpressionObject
implements org.bgerp.dao.expression.ExpressionObject {
    private static final Log log = Log.getLog();
    private static final Set<Character> SPECIAL_CHARACTERS_MD = Set.of(Character.valueOf('('), Character.valueOf(')'));
    private static final Set<String> PARSE_MODES = Set.of("MarkdownV2", "HTML");

    public static String escapeMarkdown(String text) {
        StringBuilder result = new StringBuilder(text.length());
        for (int i = 0; i < text.length(); ++i) {
            char c = text.charAt(i);
            if (SPECIAL_CHARACTERS_MD.contains(Character.valueOf(c))) {
                result.append("\\");
            }
            result.append(c);
        }
        return result.toString();
    }

    @Override
    public void toContext(Map<String, Object> context) {
        context.put("telegram", this);
    }

    public void sendMessage(String chatId, String text) {
        this.sendMessage(chatId, text, null);
    }

    public void sendMessage(String chatId, String text, String parseMode) {
        Bot bot = Bot.getInstance();
        if (bot == null) {
            throw new IllegalStateException("Telegram bot is not running");
        }
        if (Utils.isBlankString(chatId)) {
            throw new IllegalArgumentException("chatId is not defined");
        }
        if (parseMode != null && !PARSE_MODES.contains(parseMode)) {
            throw new BGException("Unsupported parseMode: {}", parseMode);
        }
        if (chatId != null && !chatId.trim().isEmpty()) {
            log.debug("Send message: {}, chatId: {}, parseMode: {}", text, chatId, parseMode);
            if (parseMode == null) {
                bot.sendMessage(chatId, text);
            } else {
                bot.sendMessage(chatId, text, parseMode);
            }
        }
    }

    public void sendMessage(Collection<Integer> userIds, String text) {
        this.sendMessage(userIds, text, null);
    }

    public void sendMessage(Collection<Integer> userIds, String text, String parseMode) {
        Config config = Setup.getSetup().getConfig(Config.class);
        Collection activeUserIds = userIds.stream().map(UserCache::getUser).filter(user -> user != null && user.getStatus() == 0).map(Id::getId).collect(Collectors.toList());
        if (userIds.isEmpty()) {
            return;
        }
        this.sendMessageForObject(activeUserIds, config.getParamId(), text, parseMode);
    }

    public void sendMessage(Process process, String text) {
        this.sendMessage(process.getExecutorIds(), text, null);
    }

    public void sendMessage(Process process, String text, String parseMode) {
        this.sendMessage(process.getExecutorIds(), text, parseMode);
    }

    public void sendMessageForProcess(Process process, String text) {
        Config config = Setup.getSetup().getConfig(Config.class);
        this.sendMessageForObject(Collections.singletonList(process.getId()), config.getProcessParamId(), text, null);
    }

    private void sendMessageForObject(Collection<Integer> objectIds, int paramId, String text, String parseMode) {
        try (Connection con = Setup.getSetup().getDBSlaveConnectionFromPool();){
            ParamValueDAO paramDAO = new ParamValueDAO(con);
            for (int objectId : objectIds) {
                String chatId = paramDAO.getParamText(objectId, paramId);
                this.sendMessage(chatId, text, parseMode);
            }
        }
        catch (SQLException ex) {
            log.error(ex);
        }
    }
}

