/*
 * Decompiled with CFR 0.152.
 */
package org.bgerp.plugin.svc.dba.dao;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import org.bgerp.model.base.IdTitle;
import org.bgerp.util.sql.PreparedQuery;
import ru.bgcrm.dao.CommonDAO;

public class QueryHistoryDAO
extends CommonDAO {
    public QueryHistoryDAO(Connection con) {
        super(con);
    }

    public void update(int userId, String query) throws SQLException {
        int rowsUpdated;
        query = query.trim();
        try (PreparedQuery pq = new PreparedQuery(this.con, "UPDATE  dba_query_history SET last_dt=NOW() WHERE user_id=? AND data=?");){
            pq.addInt(userId);
            pq.addString(query);
            rowsUpdated = pq.executeUpdate();
        }
        if (rowsUpdated == 0) {
            pq = new PreparedQuery(this.con, "INSERT INTO  dba_query_history SET user_id=?, data=?");
            try {
                pq.addInt(userId);
                pq.addString(query);
                pq.executeUpdate();
            }
            finally {
                pq.close();
            }
        }
    }

    public List<IdTitle> list(int userId) throws SQLException {
        ArrayList<IdTitle> result = new ArrayList<IdTitle>();
        String query = "SELECT id, data  FROM  dba_query_history  WHERE user_id=? ORDER BY last_dt DESC ";
        try (PreparedQuery pq = new PreparedQuery(this.con, query);){
            pq.addInt(userId);
            ResultSet rs = pq.executeQuery();
            while (rs.next()) {
                result.add(new IdTitle(rs.getInt("id"), rs.getString("data")));
            }
        }
        return result;
    }

    public String get(int userId, int id) throws SQLException {
        String res = "";
        try (PreparedQuery ps = new PreparedQuery(this.con, "SELECT data FROM  dba_query_history  WHERE user_id=? AND id=?");){
            ps.addInt(userId);
            ps.addInt(id);
            ResultSet rs = ps.executeQuery();
            if (rs.next()) {
                res = rs.getString("data");
            }
        }
        return res;
    }

    public void delete(int userId, int id) throws SQLException {
        try (PreparedQuery ps = new PreparedQuery(this.con, "DELETE FROM  dba_query_history  WHERE user_id=? AND id=?");){
            ps.addInt(userId);
            ps.addInt(id);
            ps.executeUpdate();
        }
    }
}

