/*
 * Decompiled with CFR 0.152.
 */
package ru.bgcrm.plugin.fulltext.exec;

import java.sql.Connection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.bgerp.app.cfg.Setup;
import org.bgerp.app.cfg.bean.annotation.Bean;
import org.bgerp.app.exec.scheduler.Task;
import org.bgerp.cache.ParameterCache;
import org.bgerp.dao.customer.CustomerDAO;
import org.bgerp.dao.param.ParamValueDAO;
import org.bgerp.model.msg.Message;
import org.bgerp.model.param.Parameter;
import org.bgerp.model.param.ParameterValue;
import org.bgerp.util.Log;
import org.bgerp.util.sql.pool.ConnectionPool;
import ru.bgcrm.dao.message.MessageDAO;
import ru.bgcrm.dao.process.ProcessDAO;
import ru.bgcrm.model.customer.Customer;
import ru.bgcrm.model.param.ParameterAddressValue;
import ru.bgcrm.model.param.ParameterPhoneValue;
import ru.bgcrm.model.param.ParameterPhoneValueItem;
import ru.bgcrm.model.process.Process;
import ru.bgcrm.plugin.fulltext.Plugin;
import ru.bgcrm.plugin.fulltext.dao.SearchDAO;
import ru.bgcrm.plugin.fulltext.model.Config;
import ru.bgcrm.plugin.fulltext.model.SearchItem;
import ru.bgcrm.util.TimeUtils;

@Bean(oldClasses={"ru.bgcrm.plugin.fulltext.FullTextUpdater", "ru.bgcrm.plugin.fulltext.task.FullTextUpdate"})
public class FullTextUpdate
extends Task {
    private static final Log log = Log.getLog();

    public FullTextUpdate() {
        super(null);
    }

    @Override
    public String getTitle() {
        return Plugin.INSTANCE.getLocalizer().l("FullText Index Update", new Object[0]);
    }

    @Override
    public void run() {
        Config config = Setup.getSetup().getConfig(Config.class);
        ConnectionPool connectionPool = Setup.getSetup().getConnectionPool();
        try (Connection con = connectionPool.getDBConnectionFromPool();
             Connection conSlave = connectionPool.getDBSlaveConnectionFromPool();){
            SearchDAO searchDao = new SearchDAO(con);
            ParamValueDAO paramDao = new ParamValueDAO(conSlave);
            List<SearchItem> forUpdate = null;
            while (!(forUpdate = searchDao.getScheduledUpdates(config.getIndexDelay(), 100)).isEmpty()) {
                for (SearchItem item : forUpdate) {
                    Config.ObjectType typeConfig = config.getObjectTypeMap().get(item.getObjectType());
                    if (typeConfig == null) {
                        log.warn("Not configured object type: {}", item.getObjectType());
                        searchDao.delete(item.getObjectType(), item.getObjectId());
                        continue;
                    }
                    StringBuilder text = new StringBuilder(200);
                    if ("customer".equals(item.getObjectType())) {
                        Customer customer = new CustomerDAO(conSlave).getCustomerById(item.getObjectId());
                        if (customer == null) {
                            log.warn("Customer not found: {}", item.getObjectId());
                            searchDao.delete(item);
                            continue;
                        }
                        text.append(customer.getTitle());
                        text.append('\n');
                    } else if ("process".equals(item.getObjectType())) {
                        Process process = new ProcessDAO(conSlave).getProcess(item.getObjectId());
                        if (process == null) {
                            log.warn("Process not found: {}", item.getObjectId());
                            searchDao.delete(item);
                            continue;
                        }
                        text.append(process.getDescription());
                        text.append('\n');
                    } else if ("message".equals(item.getObjectType())) {
                        Message message = new MessageDAO(conSlave).getMessageById(item.getObjectId());
                        if (message == null) {
                            log.warn("Message not found: {}", item.getObjectId());
                            searchDao.delete(item);
                            continue;
                        }
                        text.append(message.getText());
                        text.append('\n');
                    }
                    List<Parameter> paramList = ParameterCache.getParameterMap().values().stream().filter(p -> p.getObjectType().equals(item.getObjectType()) && config.isParamConfigured((Parameter)p)).collect(Collectors.toList());
                    if (!paramList.isEmpty()) {
                        List<ParameterValue> paramValues = paramDao.loadParameters(paramList, item.getObjectId(), false);
                        block27: for (ParameterValue pair : paramValues) {
                            if (pair.getValue() == null) continue;
                            switch (Parameter.Type.of(pair.getParameter().getType())) {
                                case ADDRESS: {
                                    Map valueMap = (Map)pair.getValue();
                                    for (ParameterAddressValue value : valueMap.values()) {
                                        text.append(value.getValue()).append('\n');
                                    }
                                    continue block27;
                                }
                                case BLOB: 
                                case MONEY: 
                                case TEXT: {
                                    text.append(String.valueOf(pair.getValue())).append('\n');
                                    break;
                                }
                                case DATE: {
                                    text.append(TimeUtils.format((Date)pair.getValue(), "ymd")).append('\n');
                                    break;
                                }
                                case DATETIME: {
                                    text.append(TimeUtils.format((Date)pair.getValue(), "ymdhm")).append('\n');
                                    break;
                                }
                                case EMAIL: {
                                    Map valueMap = (Map)pair.getValue();
                                    for (String email : valueMap.values()) {
                                        text.append(email);
                                        text.append('\n');
                                    }
                                    continue block27;
                                }
                                case FILE: {
                                    break;
                                }
                                case LIST: {
                                    text.append(Parameter.Type.listToString(pair.getParameter().getId(), (Map)pair.getValue())).append("\n");
                                    break;
                                }
                                case LISTCOUNT: {
                                    text.append(Parameter.Type.listCountToString(pair.getParameter().getId(), (Map)pair.getValue())).append("\n");
                                    break;
                                }
                                case PHONE: {
                                    ParameterPhoneValue value = (ParameterPhoneValue)pair.getValue();
                                    for (ParameterPhoneValueItem valueItem : value.getItemList()) {
                                        text.append(valueItem.getPhone()).append(' ').append(valueItem.getComment()).append('\n');
                                    }
                                    continue block27;
                                }
                                case TREE: {
                                    text.append(Parameter.Type.treeToString(pair.getParameter().getId(), (Set)pair.getValue())).append("\n");
                                    break;
                                }
                                case TREECOUNT: {
                                    text.append(Parameter.Type.treeCountToString(pair.getParameter().getId(), (Map)pair.getValue())).append("\n");
                                }
                            }
                        }
                    }
                    item.setText(text.toString());
                    searchDao.update(item);
                    con.commit();
                    log.debug("Item type: {}; id: {}; data: {}", item.getObjectType(), item.getObjectId(), text);
                }
            }
        }
        catch (Exception e) {
            log.error(e);
        }
    }
}

