/*
 * Decompiled with CFR 0.152.
 */
package ru.bgcrm.plugin.bgbilling.proto.dao;

import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.stream.Collectors;
import org.bgerp.app.exception.BGException;
import org.bgerp.model.Pageable;
import org.bgerp.util.Log;
import ru.bgcrm.model.Page;
import ru.bgcrm.model.user.User;
import ru.bgcrm.plugin.bgbilling.RequestJsonRpc;
import ru.bgcrm.plugin.bgbilling.proto.dao.BillingModuleDAO;
import ru.bgcrm.plugin.bgbilling.proto.model.inet.InetDevice;
import ru.bgcrm.plugin.bgbilling.proto.model.inet.InetDeviceManagerMethod;
import ru.bgcrm.plugin.bgbilling.proto.model.inet.InetService;
import ru.bgcrm.plugin.bgbilling.proto.model.inet.InetServiceOption;
import ru.bgcrm.plugin.bgbilling.proto.model.inet.InetServiceType;
import ru.bgcrm.plugin.bgbilling.proto.model.inet.InetSessionLog;
import ru.bgcrm.plugin.bgbilling.proto.model.inet.version.v8x.InetServiceType8x;

public class InetDAO
extends BillingModuleDAO {
    private static final Log log = Log.getLog();
    private final String inetModule = this.inetModule();

    public InetDAO(User user, String billingId, int moduleId) {
        super(user, billingId, moduleId);
    }

    @Deprecated
    public static InetDAO getInstance(User user, String billingId, int moduleId) {
        log.warnd("Deprecated method '{}' was called. Create a new instance using 'new' instead.", "getInstance");
        return new InetDAO(user, billingId, moduleId);
    }

    private String inetModule() {
        return this.dbInfo.versionCompare("8.0") > 0 ? "ru.bitel.bgbilling.modules.inet" : "ru.bitel.bgbilling.modules.inet.api";
    }

    public List<InetService> getServiceList(int contractId) {
        ArrayList<InetService> result = new ArrayList<InetService>();
        RequestJsonRpc req = new RequestJsonRpc(this.inetModule, this.moduleId, "InetServService", "inetServTree");
        req.setParamContractId(contractId);
        JsonNode jsonNode = this.transferData.postDataReturn(req, this.user);
        this.loadChildren(jsonNode, result);
        return result;
    }

    private void loadChildren(JsonNode node, List<InetService> list) {
        for (JsonNode childNode : node.path("children")) {
            this.correctStatus(childNode);
            list.add((InetService)this.jsonMapper.convertValue((Object)childNode, InetService.class));
            this.loadChildren(childNode, list);
        }
    }

    public InetService getService(int id) {
        RequestJsonRpc req = new RequestJsonRpc(this.inetModule, this.moduleId, "InetServService", "inetServGet");
        req.setParam("inetServId", id);
        JsonNode response = this.transferData.postDataReturn(req, this.user);
        this.correctStatus(response);
        return (InetService)this.jsonMapper.convertValue((Object)response, InetService.class);
    }

    private void correctStatus(JsonNode childNode) {
        switch (childNode.get("status").asText()) {
            case "STATUS_ON": {
                ((ObjectNode)childNode).put("status", 0);
                break;
            }
            case "STATUS_OFF": {
                ((ObjectNode)childNode).put("status", 1);
            }
        }
    }

    public void updateService(InetService inetServ, List<InetServiceOption> optionList, boolean generateLogin, boolean generatePassword, long saWaitTimeout) {
        if (optionList == null) {
            optionList = Collections.emptyList();
        }
        RequestJsonRpc req = new RequestJsonRpc(this.inetModule, this.moduleId, "InetServService", "inetServUpdate");
        req.setParam("inetServ", inetServ);
        req.setParam("optionList", optionList);
        req.setParam("generateLogin", generateLogin);
        req.setParam("generatePassword", generatePassword);
        req.setParam("saWaitTimeout", saWaitTimeout);
        this.transferData.postData(req, this.user);
    }

    public void deleteService(int id) {
        RequestJsonRpc req = new RequestJsonRpc(this.inetModule, this.moduleId, "InetServService", "inetServDelete");
        req.setParam("id", id);
        req.setParam("force", false);
        this.transferData.postData(req, this.user);
    }

    public void updateServiceState(int serviceId, int state) {
        RequestJsonRpc req = new RequestJsonRpc(this.inetModule, this.moduleId, "InetServService", "inetServStateModify");
        req.setParam("inetServId", serviceId);
        req.setParam("deviceState", state);
        req.setParam("accessCode", -2);
        this.transferData.postData(req, this.user);
    }

    public List<InetServiceType> getServiceTypeList() {
        RequestJsonRpc req = new RequestJsonRpc(this.inetModule, this.moduleId, "InetServService", "inetServTypeList");
        return (List)this.readJsonValue(this.transferData.postDataReturn(req, this.user).traverse(), (JavaType)this.jsonTypeFactory.constructCollectionType(List.class, this.dbInfo.versionCompare("8.0") > 0 ? InetServiceType8x.class : InetServiceType.class));
    }

    public InetDevice getDevice(int deviceId) {
        RequestJsonRpc req = new RequestJsonRpc(this.inetModule, this.moduleId, "InetDeviceService", "inetDeviceGet");
        req.setParam("id", deviceId);
        JsonNode fromValue = this.transferData.postDataReturn(req, this.user);
        return (InetDevice)this.jsonMapper.convertValue((Object)fromValue, InetDevice.class);
    }

    public InetDevice getRootDevice(Set<Integer> deviceTypeIds, Set<Integer> deviceGroupIds) {
        RequestJsonRpc req = new RequestJsonRpc(this.inetModule, this.moduleId, "InetDeviceService", "inetDeviceRoot");
        if (this.dbInfo.versionCompare("9.2") >= 0) {
            req.setParam("deviceTreeFilter", Map.of("host", "", "identifier", "", "loadDeviceGroupLink", "false"));
        } else {
            req.setParam("identifier", null);
            req.setParam("host", null);
            req.setParam("deviceTypeIds", deviceTypeIds);
            req.setParam("deviceGroupIds", deviceGroupIds);
            req.setParam("dateFrom", null);
            req.setParam("dateTo", null);
            req.setParam("intersectDateFrom", null);
            req.setParam("intersectDateTo", null);
            req.setParam("entityFilter", null);
            req.setParam("loadDeviceGroupIds", false);
        }
        req.setParam("loadAncestors", true);
        JsonNode fromValue = this.transferData.postDataReturn(req, this.user);
        return (InetDevice)this.jsonMapper.convertValue((Object)fromValue, InetDevice.class);
    }

    public List<InetDeviceManagerMethod> getDeviceManagerMethodList(int deviceTypeId) {
        RequestJsonRpc req = new RequestJsonRpc(this.inetModule, this.moduleId, "InetDeviceService", "deviceManagerMethodList");
        req.setParam("deviceTypeId", deviceTypeId);
        List<InetDeviceManagerMethod> methodList = (List<InetDeviceManagerMethod>)this.readJsonValue(this.transferData.postDataReturn(req, this.user).traverse(), (JavaType)this.jsonTypeFactory.constructCollectionType(List.class, InetDeviceManagerMethod.class));
        methodList = methodList.stream().filter(m -> m.getTypes().contains((Object)InetDeviceManagerMethod.DeviceManagerMethodType.ACCOUNT)).collect(Collectors.toList());
        return methodList;
    }

    public String deviceManage(int contractId, int deviceId, int serviceId, int connectionId, String operation) {
        RequestJsonRpc req = new RequestJsonRpc(this.inetModule, this.moduleId, "InetDeviceService", "deviceManage");
        req.setParamContractId(contractId);
        req.setParam("id", deviceId);
        req.setParam("inetDeviceId", deviceId);
        req.setParam("servId", serviceId);
        req.setParam("operation", operation);
        req.setParam("connectionId", connectionId);
        req.setParam("timeout", 180000);
        return (String)this.jsonMapper.convertValue((Object)this.transferData.postDataReturn(req, this.user), String.class);
    }

    public void getSessionAliveContractList(Pageable<InetSessionLog> result, int contractId) {
        RequestJsonRpc req = new RequestJsonRpc(this.inetModule, this.moduleId, "InetSessionService", "inetSessionAliveContractList");
        req.setParamContractId(contractId);
        req.setParam("trafficTypeIds", new int[]{0});
        req.setParam("serviceIds", Collections.emptyList());
        req.setParam("page", result.getPage());
        req.setParam("servIds", Collections.emptyList());
        this.extractSessions(result, req);
        this.setDeviceTitles(result);
    }

    public void getSessionLogContractList(Pageable<InetSessionLog> result, int contractId, Date dateFrom, Date dateTo) {
        RequestJsonRpc req = new RequestJsonRpc(this.inetModule, this.moduleId, "InetSessionService", "inetSessionLogContractList");
        req.setParamContractId(contractId);
        req.setParam("dateFrom", dateFrom);
        req.setParam("dateTo", dateTo);
        req.setParam("trafficTypeIds", new int[]{0});
        req.setParam("servIds", Collections.emptyList());
        req.setParam("page", result.getPage());
        this.extractSessions(result, req);
        this.setDeviceTitles(result);
    }

    private void extractSessions(Pageable<InetSessionLog> result, RequestJsonRpc req) {
        JsonNode ret = this.transferData.postDataReturn(req, this.user);
        List sessionList = (List)this.readJsonValue(ret.findValue("list").traverse(), (JavaType)this.jsonTypeFactory.constructCollectionType(List.class, InetSessionLog.class));
        result.getList().addAll(sessionList);
        result.getPage().setData((Page)this.jsonMapper.convertValue((Object)ret.findValue("page"), Page.class));
    }

    private void setDeviceTitles(Pageable<InetSessionLog> pageable) {
        TreeMap<Integer, InetDevice> deviceMap = new TreeMap<Integer, InetDevice>();
        for (InetSessionLog item : pageable.getList()) {
            InetDevice device = deviceMap.computeIfAbsent(item.getDeviceId(), id -> {
                try {
                    return this.getDevice((int)id);
                }
                catch (BGException e) {
                    log.error(e);
                    return null;
                }
            });
            item.setDeviceTitle(device.getTitle());
        }
    }

    public Set<Integer> vlanResourceCategoryIds(int deviceId) {
        RequestJsonRpc req = new RequestJsonRpc(this.inetModule, this.moduleId, "InetServService", "vlanResourceCategoryIds");
        req.setParam("deviceId", deviceId);
        Set methodList = (Set)this.readJsonValue(this.transferData.postDataReturn(req, this.user).traverse(), (JavaType)this.jsonTypeFactory.constructCollectionType(Set.class, Integer.class));
        return methodList;
    }

    public void connectionClose(int contractId, long connectionId) throws Exception {
        RequestJsonRpc req = new RequestJsonRpc(this.inetModule, this.moduleId, "InetSessionService", "connectionClose");
        req.setParam("contractId", contractId);
        req.setParam("connectionId", connectionId);
        this.transferData.postData(req, this.user);
    }

    public void connectionFinish(int contractId, long connectionId) throws Exception {
        RequestJsonRpc req = new RequestJsonRpc(this.inetModule, this.moduleId, "InetSessionService", "connectionFinish");
        req.setParam("contractId", contractId);
        req.setParam("connectionId", connectionId);
        this.transferData.postData(req, this.user);
    }
}

