/*
 * Decompiled with CFR 0.152.
 */
package ru.bgcrm.dao.process;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Date;
import java.util.List;
import java.util.Set;
import javassist.NotFoundException;
import org.apache.commons.lang3.StringUtils;
import org.bgerp.dao.param.ParamValueDAO;
import org.bgerp.dao.process.ProcessLogDAO;
import org.bgerp.model.Pageable;
import org.bgerp.model.base.IdTitle;
import org.bgerp.model.process.ProcessGroups;
import org.bgerp.model.process.config.IsolationConfig;
import org.bgerp.util.TimeConvert;
import org.bgerp.util.sql.PreparedQuery;
import ru.bgcrm.dao.CommonDAO;
import ru.bgcrm.dao.message.MessageDAO;
import ru.bgcrm.dao.process.StatusChangeDAO;
import ru.bgcrm.model.Page;
import ru.bgcrm.model.param.ParameterSearchedObject;
import ru.bgcrm.model.process.Process;
import ru.bgcrm.model.process.ProcessExecutor;
import ru.bgcrm.model.process.ProcessGroup;
import ru.bgcrm.model.user.User;
import ru.bgcrm.struts.form.DynActionForm;
import ru.bgcrm.util.Utils;

public class ProcessDAO
extends CommonDAO {
    public static final String LINKED_PROCESS = "linked";
    public static final int MODE_USER_CREATED = 1;
    public static final int MODE_USER_CLOSED = 2;
    public static final int MODE_USER_STATUS_CHANGED = 3;
    protected final DynActionForm form;

    public ProcessDAO(Connection con) {
        super(con);
        this.form = null;
    }

    public ProcessDAO(Connection con, DynActionForm form) {
        super(con);
        this.form = form;
    }

    public static Process getProcessFromRs(ResultSet rs, String prefix) throws SQLException {
        Process process = new Process();
        process.setId(rs.getInt(prefix + "id"));
        process.setTitle(rs.getString(prefix + "title"));
        process.setTypeId(rs.getInt(prefix + "type_id"));
        process.setStatusId(rs.getInt(prefix + "status_id"));
        process.setStatusTime(rs.getTimestamp(prefix + "status_dt"));
        process.setStatusUserId(rs.getInt(prefix + "status_user_id"));
        process.setCreateTime(rs.getTimestamp(prefix + "create_dt"));
        process.setCreateUserId(rs.getInt(prefix + "create_user_id"));
        process.setCloseTime(rs.getTimestamp(prefix + "close_dt"));
        process.setCloseUserId(rs.getInt(prefix + "close_user_id"));
        process.setPriority(rs.getInt(prefix + "priority"));
        process.setDescription(rs.getString(prefix + "description"));
        List<IdTitle> idTitle = Utils.parseIdTitleList(rs.getString(prefix + "groups"), "0");
        ProcessGroups processGroups = new ProcessGroups();
        for (IdTitle item : idTitle) {
            ProcessGroup processGroup = new ProcessGroup();
            processGroup.setGroupId(item.getId());
            processGroup.setRoleId(Integer.parseInt(item.getTitle()));
            processGroups.add(processGroup);
        }
        process.setGroups(processGroups);
        process.setExecutors(ProcessExecutor.parseSafe(rs.getString(prefix + "executors"), processGroups));
        return process;
    }

    public static Process getProcessFromRs(ResultSet rs) throws SQLException {
        return ProcessDAO.getProcessFromRs(rs, "process.");
    }

    public static String getIsolationJoin(DynActionForm form, String tableProcess) {
        if (form == null) {
            return "";
        }
        User user = form.getUser();
        IsolationConfig.IsolationProcess isolation = user.getConfigMap().getConfig(IsolationConfig.class).getIsolationProcess();
        if (isolation.getType() == IsolationConfig.IsolationProcess.Type.EXECUTOR) {
            return " INNER JOIN  process_executor  AS isol_e ON " + tableProcess + ".id=isol_e.process_id AND isol_e.user_id=" + user.getId() + " ";
        }
        if (isolation.getType() == IsolationConfig.IsolationProcess.Type.GROUP) {
            String result = " INNER JOIN  process_group  AS isol_pg ON " + tableProcess + ".id=isol_pg.process_id INNER JOIN  user_group  AS isol_ur ON isol_ur.group_id=isol_pg.group_id AND isol_ur.user_id=" + user.getId() + " AND (isol_ur.date_to IS NULL OR CURDATE()<=isol_ur.date_to) ";
            if (StringUtils.isNotBlank((CharSequence)isolation.getExecutorTypeIds())) {
                result = result + " INNER JOIN  process  AS isol_ge ON " + tableProcess + ".id=isol_ge.id AND (" + tableProcess + ".type_id NOT IN (" + isolation.getExecutorTypeIds() + ") OR isol_ge.executors LIKE '" + user.getId() + ":%'OR POSITION(', " + user.getId() + ":' IN isol_ge.executors) > 0 OR POSITION('," + user.getId() + ":' IN isol_ge.executors) > 0  )";
            }
            return result;
        }
        return "";
    }

    public Process getProcess(int id) throws SQLException {
        Process result = null;
        String query = "SELECT process.*, ps.*  FROM  process  AS process LEFT JOIN  process_status  AS ps ON process.id=ps.process_id AND ps.status_id=process.status_id AND ps.last " + ProcessDAO.getIsolationJoin(this.form, "process") + " WHERE process.id=?";
        PreparedStatement ps = this.con.prepareStatement(query);
        ps.setInt(1, id);
        ResultSet rs = ps.executeQuery();
        if (rs.next()) {
            result = ProcessDAO.getProcessFromRs(rs);
            result.setStatusChange(StatusChangeDAO.getProcessStatusFromRs(rs, "ps."));
        }
        ps.close();
        return result;
    }

    public Process getProcessOrThrow(int id) throws SQLException, NotFoundException {
        Process result = this.getProcess(id);
        if (result == null) {
            throw new NotFoundException("Process not found: " + id);
        }
        return result;
    }

    public void updateProcessTitle(int processId, String title) throws SQLException {
        String query = "UPDATE  process  SET title=? WHERE id=?";
        try (PreparedStatement ps = this.con.prepareStatement(query);){
            ps.setString(1, title);
            ps.setInt(2, processId);
            ps.executeUpdate();
        }
    }

    public void updateProcessGroups(Set<ProcessGroup> processGroups, int processId) throws SQLException {
        if (this.form != null) {
            Process oldValue = new ProcessDAO(this.con).getProcess(processId);
            Process newValue = oldValue.clone();
            newValue.setGroups(new ProcessGroups(processGroups));
            this.logProcessChange(newValue, oldValue);
        }
        this.updateColumn(" process ", processId, "groups", ProcessGroup.serialize(processGroups));
        String query = "DELETE FROM  process_group  WHERE process_id=?";
        PreparedStatement ps = this.con.prepareStatement(query);
        ps.setInt(1, processId);
        ps.executeUpdate();
        ps.close();
        query = "INSERT INTO  process_group VALUES (?, ?, ?)";
        ps = this.con.prepareStatement(query);
        ps.setInt(1, processId);
        for (ProcessGroup item : processGroups) {
            ps.setInt(2, item.getGroupId());
            ps.setInt(3, item.getRoleId());
            ps.executeUpdate();
        }
        ps.close();
    }

    public void updateProcessExecutors(Set<ProcessExecutor> processExecutors, int processId) throws SQLException {
        if (this.form != null) {
            Process oldValue = new ProcessDAO(this.con).getProcess(processId);
            Process newValue = oldValue.clone();
            newValue.setExecutors(processExecutors);
            this.logProcessChange(newValue, oldValue);
        }
        this.updateColumn(" process ", processId, "executors", ProcessExecutor.serialize(processExecutors));
        String query = "DELETE FROM  process_executor  WHERE process_id=?";
        PreparedStatement ps = this.con.prepareStatement(query);
        ps.setInt(1, processId);
        ps.executeUpdate();
        ps.close();
        query = "INSERT INTO  process_executor  ( process_id, group_id, role_id, user_id ) VALUES ( ?, ?, ?, ? ) ";
        ps = this.con.prepareStatement(query);
        ps.setInt(1, processId);
        for (ProcessExecutor processExecutor : processExecutors) {
            ps.setInt(2, processExecutor.getGroupId());
            ps.setInt(3, processExecutor.getRoleId());
            ps.setInt(4, processExecutor.getUserId());
            ps.executeUpdate();
        }
        ps.close();
    }

    private void logProcessChange(Process process, Process oldProcess) throws SQLException {
        new ProcessLogDAO(this.con).insertEntityLog(process.getId(), this.form.getUserId(), process.getChangesLog(oldProcess));
    }

    public Process updateProcess(Process process) throws SQLException {
        if (process != null) {
            Process oldProcess = this.getProcess(process.getId());
            if (this.form != null && oldProcess != null && !oldProcess.isEqualProperties(process)) {
                this.logProcessChange(process, oldProcess);
            }
            int index = 1;
            PreparedStatement ps = null;
            StringBuilder query = new StringBuilder();
            if (oldProcess != null) {
                query.append("UPDATE  process  SET status_id=?, status_dt=?, status_user_id=?, description=?, close_dt=?, priority=?, close_user_id=?, type_id=? WHERE id=?");
                ps = this.con.prepareStatement(query.toString());
                ps.setInt(index++, process.getStatusId());
                ps.setTimestamp(index++, TimeConvert.toTimestamp(process.getStatusTime()));
                ps.setInt(index++, process.getStatusUserId());
                ps.setString(index++, process.getDescription());
                ps.setTimestamp(index++, TimeConvert.toTimestamp(process.getCloseTime()));
                ps.setInt(index++, process.getPriority());
                ps.setInt(index++, process.getCloseUserId());
                ps.setInt(index++, process.getTypeId());
                ps.setInt(index++, process.getId());
                ps.executeUpdate();
            } else {
                if (process.getCreateTime() == null) {
                    process.setCreateTime(new Date());
                }
                query.append("INSERT INTO  process  SET type_id=?, status_id=?, status_user_id=?, status_dt=?, description=?, create_dt=?, executors=?, create_user_id=?");
                ps = this.con.prepareStatement(query.toString(), 1);
                ps.setInt(index++, process.getTypeId());
                ps.setInt(index++, process.getStatusId());
                ps.setInt(index++, process.getStatusUserId());
                ps.setTimestamp(index++, TimeConvert.toTimestamp(process.getCreateTime()));
                ps.setString(index++, process.getDescription());
                ps.setTimestamp(index++, TimeConvert.toTimestamp(process.getCreateTime()));
                ps.setString(index++, ProcessExecutor.serialize(process.getExecutors()));
                ps.setInt(index++, process.getCreateUserId());
                ps.executeUpdate();
                process.setId(this.lastInsertId(ps));
            }
            ps.close();
        }
        return process;
    }

    public void deleteProcess(int processId) throws SQLException {
        this.deleteProcessData(processId, "DELETE FROM  process  WHERE id=?");
        this.deleteProcessData(processId, "DELETE FROM  process_group  WHERE process_id=?");
        this.deleteProcessData(processId, "DELETE FROM  process_executor  WHERE process_id=?");
        this.deleteProcessData(processId, "DELETE FROM  process_link  WHERE process_id=?");
        this.deleteProcessData(processId, "DELETE FROM  process_link  WHERE object_id=? AND object_type LIKE 'process%'");
        new ParamValueDAO(this.con).deleteParams("process", processId);
        new MessageDAO(this.con).deleteProcessMessages(processId);
        new ProcessLogDAO(this.con).deleteHistory(processId);
    }

    private void deleteProcessData(int processId, String query) throws SQLException {
        PreparedStatement ps = this.con.prepareStatement(query);
        ps.setInt(1, processId);
        ps.executeUpdate();
        ps.close();
    }

    public void processIdInvert(Process process) throws SQLException {
        int currentProcessId = process.getId();
        this.updateProcessId(currentProcessId, "UPDATE  process  SET id=? WHERE id=?");
        this.updateProcessId(currentProcessId, "UPDATE  process_group  SET process_id=? WHERE process_id=?");
        this.updateProcessId(currentProcessId, "UPDATE  process_executor  SET process_id=? WHERE process_id=?");
        this.updateProcessId(currentProcessId, "UPDATE  process_link  SET process_id=? WHERE process_id=?");
        this.updateProcessId(currentProcessId, "UPDATE  process_link  SET object_id=? WHERE object_id=? AND object_type LIKE 'process%'");
        new ParamValueDAO(this.con).objectIdInvert("process", currentProcessId);
        process.setId(-currentProcessId);
    }

    private void updateProcessId(int currentProcessId, String query) throws SQLException {
        PreparedStatement ps = this.con.prepareStatement(query);
        ps.setInt(1, -currentProcessId);
        ps.setInt(2, currentProcessId);
        ps.executeUpdate();
        ps.close();
    }

    public void searchProcessListByAddress(Pageable<ParameterSearchedObject<Process>> searchResult, Set<Integer> typeIds, Set<Integer> addressParamIds, int houseId, String houseFlat, String houseRoom) throws SQLException {
        if (searchResult != null) {
            Page page = searchResult.getPage();
            List<ParameterSearchedObject<Process>> list = searchResult.getList();
            PreparedQuery ps = new PreparedQuery(this.con);
            String ids = Utils.toString(addressParamIds);
            ps.addQuery("SELECT SQL_CALC_FOUND_ROWS ");
            ps.addQuery("DISTINCT param.param_id, param.value, process.*, type.title, status.title ");
            ps.addQuery(" FROM ");
            ps.addQuery(" process ");
            ps.addQuery("AS process");
            ps.addQuery(" INNER JOIN ");
            ps.addQuery(" param_address ");
            ps.addQuery("AS param ON c.id=param.id AND param.param_id IN (");
            ps.addQuery(ids);
            ps.addQuery(")");
            ps.addQuery(" AND param.house_id=?");
            ps.addInt(houseId);
            if (Utils.notBlankString(houseFlat)) {
                ps.addQuery(" AND param.flat=?");
                ps.addString(houseFlat);
            }
            if (Utils.notBlankString(houseRoom)) {
                ps.addQuery(" AND param.room=?");
                ps.addString(houseRoom);
            }
            ps.addQuery(" LEFT JOIN  process_type  AS type ON process.type_id=type.id ");
            ps.addQuery(" LEFT JOIN  process_status_title  AS status ON status.id = process.status_id ");
            ps.addQuery(" WHERE 1>0 ");
            if (typeIds != null && typeIds.size() > 0) {
                ps.addQuery(" AND process.type_id IN ");
                ps.addQuery(Utils.toString(typeIds));
                ps.addQuery(" )");
            }
            ps.addQuery(" ORDER BY ");
            ps.addQuery("p.create_dt");
            ps.addQuery(page.getLimitSql());
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                list.add(new ParameterSearchedObject<Process>(ProcessDAO.getProcessFromRs(rs), rs.getInt(1), rs.getString(2)));
            }
            page.setRecordCount(ps.getPrepared());
            ps.close();
        }
    }

    @Deprecated
    public void searchProcessListForUser(Pageable<Process> searchResult, int userId, Boolean open) throws SQLException {
        Page page = searchResult.getPage();
        List<Process> list = searchResult.getList();
        PreparedQuery pq = new PreparedQuery(this.con);
        pq.addQuery("SELECT SQL_CALC_FOUND_ROWS ");
        pq.addQuery("DISTINCT p.*");
        pq.addQuery(" FROM ");
        pq.addQuery(" process ");
        pq.addQuery("AS p ");
        pq.addQuery(" INNER JOIN ");
        pq.addQuery(" process_executor ");
        pq.addQuery("AS e ON e.process_id=p.id AND e.user_id=?");
        pq.addInt(userId);
        this.addOpenFilter(pq, open);
        pq.addQuery(" ORDER BY ");
        pq.addQuery("create_dt DESC");
        pq.addQuery(page.getLimitSql());
        ResultSet rs = pq.executeQuery();
        while (rs.next()) {
            list.add(ProcessDAO.getProcessFromRs(rs, ""));
        }
        page.setRecordCount(pq.getPrepared());
        pq.close();
    }

    private void addOpenFilter(PreparedQuery pq, Boolean open) {
        if (open != null) {
            if (open.booleanValue()) {
                pq.addQuery(" WHERE close_dt IS NULL ");
            } else {
                pq.addQuery(" WHERE close_dt IS NOT NULL ");
            }
        }
    }

    public void searchProcessListForUser(Pageable<Process> searchResult, int userId, int mode) throws SQLException {
        if (searchResult != null) {
            Page page = searchResult.getPage();
            List<Process> list = searchResult.getList();
            PreparedQuery pq = new PreparedQuery(this.con);
            pq.addQuery("SELECT SQL_CALC_FOUND_ROWS ");
            pq.addQuery("*");
            pq.addQuery(" FROM ");
            pq.addQuery(" process  AS p ");
            pq.addQuery(ProcessDAO.getIsolationJoin(this.form, "p"));
            String groupBy = " GROUP BY p.id ";
            if (mode == 1) {
                pq.addQuery("WHERE p.create_user_id=?");
                pq.addInt(userId);
                pq.addQuery(" AND p.close_dt is NULL");
                pq.addQuery(" GROUP BY p.id ");
                pq.addQuery(" ORDER BY ");
                pq.addQuery("p.create_dt DESC");
            } else if (mode == 2) {
                pq.addQuery("WHERE p.close_user_id=?");
                pq.addInt(userId);
                pq.addQuery(" GROUP BY p.id ");
                pq.addQuery(" ORDER BY ");
                pq.addQuery("p.close_dt DESC");
            } else if (mode == 3) {
                pq.addQuery("WHERE p.status_user_id=?");
                pq.addInt(userId);
                pq.addQuery(" GROUP BY p.id ");
                pq.addQuery(" ORDER BY ");
                pq.addQuery("p.status_dt DESC");
            }
            pq.addQuery(page.getLimitSql());
            ResultSet rs = pq.executeQuery();
            while (rs.next()) {
                list.add(ProcessDAO.getProcessFromRs(rs, "p."));
            }
            page.setRecordCount(pq.getPrepared());
            pq.close();
        }
    }
}

