/*
 * Decompiled with CFR 0.152.
 */
package ru.bgcrm.util.inet;

import java.math.BigInteger;
import java.util.Base64;
import java.util.StringTokenizer;
import java.util.regex.Pattern;
import ru.bgcrm.util.Utils;
import ru.bgcrm.util.inet.IpAddress;

public class IPUtils {
    private static final Pattern IPV4_PATTERN = Pattern.compile("^(?:(?:25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)\\.){3}(?:25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)$");

    public static final boolean validateIPv4(String ip) {
        return IPV4_PATTERN.matcher(ip).matches();
    }

    public static final long convertStringIPtoLong(String ip_value) {
        return IPUtils.convertStringIPtoLong(ip_value, 0L);
    }

    public static final long convertStringIPtoLong(String ip_value, long error) {
        long val = 0L;
        try {
            StringTokenizer st = new StringTokenizer(ip_value, ".");
            if (st.hasMoreTokens()) {
                val |= Long.parseLong(st.nextToken()) << 24;
            }
            if (st.hasMoreTokens()) {
                val |= Long.parseLong(st.nextToken()) << 16;
            }
            if (st.hasMoreTokens()) {
                val |= Long.parseLong(st.nextToken()) << 8;
            }
            if (st.hasMoreTokens()) {
                val |= Long.parseLong(st.nextToken());
            }
            val &= 0xFFFFFFFFL;
        }
        catch (Exception ex) {
            val = error;
        }
        return val;
    }

    public static long isIPaddress(String ipAddress) {
        char tempchar;
        if (ipAddress == null || ipAddress.length() == 0) {
            return 0L;
        }
        int pointNum = 0;
        int numberNum = 0;
        int numberVal = 0;
        int len = ipAddress.length();
        int m = 0;
        long IPVal = 0L;
        while (m < len && ((tempchar = ipAddress.charAt(m)) == '.' || Character.isDigit(tempchar))) {
            ++m;
            if ('0' <= tempchar && tempchar <= '9') {
                if (numberNum > 2) {
                    return -1L;
                }
                numberVal *= 10;
                if ((numberVal += tempchar - 48) > 255) {
                    return -1L;
                }
                ++numberNum;
                continue;
            }
            if (numberNum == 0) {
                return -1L;
            }
            if (pointNum == 3) {
                return -1L;
            }
            ++pointNum;
            IPVal *= 256L;
            IPVal += (long)numberVal;
            numberNum = 0;
            numberVal = 0;
        }
        if (m != len || pointNum != 3 || numberNum == 0) {
            return -1L;
        }
        ++pointNum;
        IPVal *= 256L;
        return IPVal += (long)numberVal;
    }

    public static final String convertLongIpToString(long ip) {
        Object net = "0.0.0.0";
        if (ip > 0L) {
            long b1 = (ip & 0xFFFFFFFFFF000000L) >> 24;
            long b2 = (ip & 0xFF0000L) >> 16;
            long b3 = (ip & 0xFF00L) >> 8;
            long b4 = ip & 0xFFL;
            net = b1 + "." + b2 + "." + b3 + "." + b4;
        }
        return net;
    }

    public static final int convertStringIPtoInt(String ip_value) {
        StringTokenizer st;
        int result = 0;
        try {
            st = new StringTokenizer(ip_value, ".");
            if (st.countTokens() != 4) {
                return 0;
            }
            result |= Integer.parseInt(st.nextToken()) << 24;
            result |= Integer.parseInt(st.nextToken()) << 16;
            result |= Integer.parseInt(st.nextToken()) << 8;
        }
        catch (Exception ex) {
            return 0;
        }
        return result |= Integer.parseInt(st.nextToken());
    }

    public static final String convertIpToString(int ip) {
        Object net = "0.0.0.0";
        if (ip != 0) {
            byte[] b = IPUtils.convertIntToBytes(ip);
            net = IPUtils.unsignedByteToInt(b[0]) + "." + IPUtils.unsignedByteToInt(b[1]) + "." + IPUtils.unsignedByteToInt(b[2]) + "." + IPUtils.unsignedByteToInt(b[3]);
        }
        return net;
    }

    public static byte[] convertIntToBytes(int value) {
        byte[] byteValue = new byte[4];
        for (int i = 0; i < 4; ++i) {
            byteValue[3 - i] = (byte)(value & 0xFF);
            value >>= 8;
        }
        return byteValue;
    }

    public static final int unsignedByteToInt(byte value) {
        int val = value;
        if (val < 0) {
            val &= 0xFF;
            val |= 0x80;
        }
        return val;
    }

    public static int convertBytesToInt(byte[] bytes) {
        int result = 0;
        if (bytes != null && bytes.length == 4) {
            result = 0xFF & bytes[3] | 0xFF00 & bytes[2] << 8 | 0xFF0000 & bytes[1] << 16 | 0xFF000000 & bytes[0] << 24;
        }
        return result;
    }

    public static final long[] netMaskToRange(long net, long mask) {
        long[] result = new long[]{net, net | (mask != 0L ? 0xFFFFFFFFL % mask : 0xFFFFFFFFL)};
        return result;
    }

    public static final long[] netMaskToRange(long address, int netSize) {
        long[] result = new long[2];
        long rawAddr = address;
        long temlate = netSize == 0 ? 0L : 0xFFFFFFFFL << 32 - netSize & 0xFFFFFFFFL;
        result[0] = rawAddr & temlate;
        temlate = 0xFFFFFFFFL >> netSize;
        result[1] = rawAddr | temlate;
        return result;
    }

    public static final long getMask(int size) {
        long result = 0L;
        if (size <= 32) {
            for (int i = 0; i < size; ++i) {
                result |= (long)(1 << 31 - i);
            }
        }
        return result;
    }

    public static Netv4 subnet(long address1, long address2, short bitmask) {
        long network;
        if (address1 <= 0L || address2 >= 0xFFFFFFFFL) {
            return null;
        }
        if (address1 > address2) {
            return null;
        }
        for (network = address1 - 1L; network < address2 && (network & 0xFFFFFFFFL >>> bitmask) != 0L; ++network) {
        }
        if (network >= address2) {
            return null;
        }
        Netv4 netv4 = IPUtils.getNet(network + 1L, bitmask);
        ++netv4.hostMax;
        --netv4.hostMin;
        if (netv4.hostMax > address2) {
            return null;
        }
        return netv4;
    }

    public static Netv4 getNet(long address, short bitmask) {
        long netmask = 0xFFFFFFFFL << 32 - bitmask & 0xFFFFFFFFL;
        long wildcard = netmask ^ 0xFFFFFFFFL;
        long network = address & netmask;
        long broadcast = address | wildcard;
        long hostMin = network + 1L;
        long hostMax = broadcast - 1L;
        long hosts = hostMax - hostMin + 1L;
        return new Netv4(address, bitmask, netmask, wildcard, network, hostMin, hostMax, broadcast, hosts);
    }

    public static final boolean isRangeValidNet(byte[] addrFrom, byte[] addrTo) {
        if (addrFrom == null || addrTo == null || addrFrom.length != addrTo.length) {
            return false;
        }
        BigInteger aFrom = IpAddress.convertIp4AddresToBigInt(addrFrom);
        BigInteger aTo = IpAddress.convertIp4AddresToBigInt(addrTo);
        int bits = addrFrom.length * 8;
        boolean diffStart = false;
        for (int i = bits - 1; i >= 0; --i) {
            boolean bitNetStart = aFrom.testBit(i);
            boolean bitNetEnd = aTo.testBit(i);
            if (diffStart) {
                if (!bitNetStart && bitNetEnd) continue;
                return false;
            }
            diffStart = bitNetStart != bitNetEnd;
        }
        return true;
    }

    public static String getStringRange(IpAddress from, IpAddress to) {
        Object address = from.equals(to) ? from.toString() : from.toString() + "-" + to.toString();
        return address;
    }

    public static String base64ToString(String base64Addr) {
        if (Utils.isBlankString(base64Addr)) {
            return base64Addr;
        }
        return IPUtils.convertIpToString(IPUtils.convertBytesToInt(Base64.getDecoder().decode(base64Addr)));
    }

    public static String stringToBase64(String addr) {
        if (Utils.isBlankString(addr)) {
            return addr;
        }
        return Base64.getEncoder().encodeToString(IPUtils.convertIntToBytes(IPUtils.convertStringIPtoInt(addr)));
    }

    public static class Netv4 {
        public final long address;
        public final int bitmask;
        public final long netmask;
        public final long wildcard;
        public final long network;
        public long hostMin;
        public long hostMax;
        public final long broadcast;
        public final long hosts;

        Netv4(long address, short bitmask, long netmask, long wildcard, long network, long hostMin, long hostMax, long broadcast, long hosts) {
            this.address = address;
            this.bitmask = bitmask;
            this.netmask = netmask;
            this.wildcard = wildcard;
            this.network = network;
            this.hostMin = hostMin;
            this.hostMax = hostMax;
            this.broadcast = broadcast;
            this.hosts = hosts;
        }
    }
}

