/*
 * Decompiled with CFR 0.152.
 */
package ru.bgcrm.struts.action;

import java.sql.Connection;
import java.util.Date;
import java.util.Map;
import org.apache.struts.action.ActionForward;
import org.bgerp.action.base.BaseAction;
import org.bgerp.app.cfg.Preferences;
import org.bgerp.app.exception.BGMessageException;
import org.bgerp.cache.UserCache;
import ru.bgcrm.dao.user.UserDAO;
import ru.bgcrm.model.user.User;
import ru.bgcrm.servlet.ActionServlet;
import ru.bgcrm.struts.form.DynActionForm;
import ru.bgcrm.util.PswdUtil;
import ru.bgcrm.util.Utils;
import ru.bgcrm.util.sql.ConnectionSet;

@ActionServlet.Action(path="/user/profile")
public class ProfileAction
extends BaseAction {
    private static final String PATH_JSP = "/WEB-INF/jspf/user/profile";

    @Override
    public ActionForward unspecified(DynActionForm form, ConnectionSet conSet) throws Exception {
        return this.getUserProfile(form, conSet);
    }

    public ActionForward getUserProfile(DynActionForm form, ConnectionSet conSet) throws Exception {
        return this.html(conSet, form, "/WEB-INF/jspf/user/profile/default.jsp");
    }

    public ActionForward settings(DynActionForm form, Connection con) throws Exception {
        String subAction;
        int requestedUserId = form.getParamInt("requestUserId", 0);
        UserDAO userDAO = new UserDAO(con);
        User user = UserCache.getUser(requestedUserId > 0 ? requestedUserId : form.getUserId());
        String string = subAction = form.getParam("subAction") == null ? "" : form.getParam("subAction");
        if (user != null) {
            form.setResponseData("user", user);
            form.setResponseData("userGroupList", UserCache.getUserGroupList(user.getId(), new Date()));
            form.setResponseData("grantedPermission", userDAO.getPermissions(user.getId()));
        }
        if (subAction.equals("parameters")) {
            return this.html(con, form, "/WEB-INF/jspf/user/profile/parameters.jsp");
        }
        return this.html(con, form, "/WEB-INF/jspf/user/profile/settings.jsp");
    }

    public ActionForward updateSettings(DynActionForm form, Connection con) throws Exception {
        User user = UserCache.getUser(form.getUserId());
        UserDAO userDAO = new UserDAO(con);
        String userName = form.getParam("userName");
        String userLogin = form.getParam("userLogin");
        String userPassword = form.getParam("userPassword", "");
        if (Utils.isBlankString(userName)) {
            throw new BGMessageException("\u041d\u0435 \u0443\u043a\u0430\u0437\u0430\u043d \u043b\u043e\u0433\u0438\u043d.", new Object[0]);
        }
        if (userDAO.getUserByLogin(userLogin) != null && userDAO.getUserByLogin(userLogin).getId().intValue() != form.getUserId()) {
            throw new BGMessageException("\u041f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u0442\u0435\u043b\u044c \u0441 \u0434\u0430\u043d\u043d\u044b\u043c \u043b\u043e\u0433\u0438\u043d\u043e\u043c \u0443\u0436\u0435 \u0441\u0443\u0449\u0435\u0441\u0442\u0432\u0443\u0435\u0442,", new Object[0]);
        }
        if (Utils.isBlankString(userName)) {
            throw new BGMessageException("\u041d\u0435 \u0443\u043a\u0430\u0437\u0430\u043d\u043e \u0438\u043c\u044f.", new Object[0]);
        }
        new PswdUtil.UserPswdUtil(this.setup).checkPassword(userPassword);
        user.setTitle(userName);
        user.setLogin(userLogin);
        user.setPassword(userPassword);
        user.setComment(form.getParam("userDescription"));
        userDAO.updateUser(user);
        UserCache.flush(con);
        return this.json(con, form);
    }

    public ActionForward updatePersonalization(DynActionForm form, Connection con) throws Exception {
        User user = UserCache.getUser(form.getUserId());
        UserDAO userDAO = new UserDAO(con);
        Preferences map = user.getPersonalizationMap();
        String mapDataBefore = map.getDataString();
        if (form.getParamBoolean("overwrite")) {
            map.clear();
        }
        for (Map.Entry me : form.getHttpRequest().getParameterMap().entrySet()) {
            String key = (String)me.getKey();
            String value = ((String[])me.getValue())[0];
            if (!key.startsWith("iface.")) continue;
            map.put(key.replace('_', '.'), value);
        }
        if (form.getParamBoolean("reset")) {
            map.clear();
        }
        userDAO.updatePersonalization(mapDataBefore, user);
        UserCache.flush(con);
        return this.json(con, form);
    }
}

