/*
 * Decompiled with CFR 0.152.
 */
package ru.bgcrm.plugin.document.docgen;

import com.itextpdf.text.pdf.AcroFields;
import com.itextpdf.text.pdf.BaseFont;
import com.itextpdf.text.pdf.PdfReader;
import com.itextpdf.text.pdf.PdfStamper;
import java.io.ByteArrayOutputStream;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintStream;
import java.nio.charset.StandardCharsets;
import java.util.HashSet;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import org.apache.log4j.Logger;
import org.apache.log4j.lf5.util.StreamUtils;
import org.bgerp.app.event.iface.Event;
import org.bgerp.app.event.iface.EventListener;
import org.bgerp.app.exception.BGException;
import org.bgerp.app.servlet.util.ServletResponseInterceptor;
import org.bgerp.util.xml.XMLUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import ru.bgcrm.model.Pair;
import ru.bgcrm.plugin.document.dao.DocumentDAO;
import ru.bgcrm.plugin.document.event.DocumentGenerateEvent;
import ru.bgcrm.plugin.document.model.Pattern;
import ru.bgcrm.util.RegexpStringUtils;
import ru.bgcrm.util.Utils;
import ru.bgcrm.util.sql.ConnectionSet;

public class CommonDocumentGenerator
implements EventListener<Event> {
    private static final Logger log = Logger.getLogger(CommonDocumentGenerator.class);
    protected ConnectionSet conSet;
    protected DocumentGenerateEvent event;

    public CommonDocumentGenerator() {
    }

    public CommonDocumentGenerator(Event e, ConnectionSet conSet) {
        this.event = (DocumentGenerateEvent)e;
        this.conSet = conSet;
    }

    @Override
    public void notify(Event e, ConnectionSet conSet) {
        this.event = (DocumentGenerateEvent)e;
        this.conSet = conSet;
        try {
            Pattern pattern = this.event.getPattern();
            ByteArrayOutputStream result = new ByteArrayOutputStream(1000000);
            int type = pattern.getType();
            if (this.event.isDebug()) {
                OutputStreamWriter writer = new OutputStreamWriter((OutputStream)result, StandardCharsets.UTF_8);
                writer.write("\u0413\u0435\u043d\u0435\u0440\u0430\u0446\u0438\u044f \u043e\u0442\u0447\u0451\u0442\u0430 \u0432 \u0440\u0435\u0436\u0438\u043c\u0435 \u043e\u0442\u043b\u0430\u0434\u043a\u0438.\n\n");
                writer.write("\u0421\u043e\u0431\u044b\u0442\u0438\u0435, \u043f\u0435\u0440\u0435\u0434\u0430\u043d\u043d\u043e\u0435 \u0432 \u0441\u043a\u0440\u0438\u043f\u0442:\n");
                writer.write(this.event.toString());
                writer.write("\n\n");
                writer.write("\u0428\u0430\u0431\u043b\u043e\u043d: ");
                writer.write(pattern.toString());
                if (type == 7 || type == 4) {
                    writer.write("\n\n\u0414\u043b\u044f \u0434\u0430\u043d\u043d\u044b\u0445 \u0442\u0438\u043f\u043e\u0432 \u043e\u0442\u043b\u0430\u0434\u043a\u0430 \u043c\u043e\u0436\u0435\u0442 \u043f\u0440\u043e\u0438\u0437\u0432\u043e\u0434\u0438\u0442\u0441\u044f \u0432 \u0440\u0435\u0437\u0443\u043b\u044c\u0442\u0430\u0442.");
                    writer.flush();
                } else {
                    int objectId = this.event.getObjectId();
                    writer.write("\n\n");
                    writer.write("\u041a\u043e\u0434 \u043e\u0431\u044a\u0435\u043a\u0442\u0430: ");
                    writer.write(String.valueOf(objectId));
                    writer.write("\n\n");
                    try {
                        Pair<Document, String> processResult = this.processToDocument(objectId);
                        writer.write("\u041f\u043e\u0434\u0433\u043e\u0442\u043e\u0432\u043b\u0435\u043d\u043d\u044b\u0435 \u0434\u0430\u043d\u043d\u044b\u0435:\n");
                        writer.flush();
                        XMLUtils.serialize(processResult.getFirst(), result, null, true);
                        if (processResult.getSecond() != null) {
                            writer.write("\n\n");
                            writer.write("\u041e\u0442\u043b\u0430\u0434\u043a\u0430:\n");
                            writer.flush();
                            writer.write(processResult.getSecond());
                        }
                    }
                    catch (Exception ex) {
                        writer.write("\u041e\u0448\u0438\u0431\u043a\u0430 \u0432\u044b\u043f\u043e\u043b\u043d\u0435\u043d\u0438\u044f:\n");
                        writer.flush();
                        ex.printStackTrace(new PrintStream((OutputStream)result, true, StandardCharsets.UTF_8.name()));
                        log.error((Object)ex.getMessage(), (Throwable)ex);
                    }
                }
                writer.flush();
            } else if (type == 1) {
                docData = this.processToDocument(this.event.getObjectId()).getFirst();
                BaseFont bf = BaseFont.createFont((String)("jar:" + this.getClass().getResource("/ru/bitel/fonts/arial.ttf").getPath()), (String)"Identity-H", (boolean)true);
                PdfReader reader = new PdfReader(pattern.getFile());
                PdfStamper stamper = new PdfStamper(reader, (OutputStream)result);
                AcroFields fields = stamper.getAcroFields();
                fields.addSubstitutionFont(bf);
                for (String key : fields.getFields().keySet()) {
                    String value;
                    if (docData == null || docData.getDocumentElement() == null || !Utils.notBlankString(value = XMLUtils.selectText(docData.getDocumentElement(), "/data/field[@name='" + key + "']/text()"))) continue;
                    fields.setField(key, value);
                }
                if (pattern.getParams().getBoolean("flattening", false)) {
                    stamper.setFormFlattening(true);
                }
                stamper.close();
            } else if (type == 2 || type == 3) {
                docData = this.processToDocument(this.event.getObjectId()).getFirst();
                ZipInputStream zis = new ZipInputStream(new FileInputStream(pattern.getFile()));
                ZipOutputStream zos = new ZipOutputStream(result);
                HashSet<String> replacedFileSet = new HashSet<String>();
                if (type == 2) {
                    replacedFileSet.add("word/document.xml");
                } else {
                    replacedFileSet.add("content.xml");
                    replacedFileSet.add("styles.xml");
                }
                ZipEntry ze = null;
                while ((ze = zis.getNextEntry()) != null) {
                    if (!replacedFileSet.contains(ze.getName())) {
                        zos.putNextEntry(new ZipEntry(ze.getName()));
                        StreamUtils.copy((InputStream)zis, (OutputStream)zos, (int)1024);
                        continue;
                    }
                    String replaced = new String(StreamUtils.getBytes((InputStream)zis), StandardCharsets.UTF_8);
                    List<String> variables = RegexpStringUtils.findMatchesByTemplate(replaced, "\\$\\{[a-zA-Z\u0430-\u044f\u0410-\u042f0-9_.]+\\}");
                    for (String var : variables) {
                        var = var.substring(2, var.length() - 1);
                        String value = "";
                        value = XMLUtils.selectText(docData.getDocumentElement(), "/data/field[@name='" + var + "']/text()", "");
                        replaced = replaced.replaceAll("\\$\\{" + var + "\\}", value);
                    }
                    zos.putNextEntry(new ZipEntry(ze.getName()));
                    zos.write(replaced.getBytes(StandardCharsets.UTF_8));
                }
                zos.close();
                zis.close();
            } else if (type == 4) {
                docData = this.event.getObjectIds().iterator();
                while (docData.hasNext()) {
                    int objectId = (Integer)docData.next();
                    XMLUtils.serialize(this.processToDocument(objectId).getFirst(), result, null, true);
                }
            } else if (type == 7) {
                ServletResponseInterceptor resp = new ServletResponseInterceptor(this.event.getForm().getHttpResponse(), result);
                HttpServletRequest req = this.event.getForm().getHttpRequest();
                req.setAttribute("event", (Object)this.event);
                req.setAttribute("conSlave", (Object)conSet.getSlaveConnection());
                req.getRequestDispatcher(pattern.getJsp()).include((ServletRequest)req, (ServletResponse)resp);
                resp.flush();
            }
            if (!"stream".equals(this.event.getForm().getResponseType())) {
                DocumentDAO docDao = new DocumentDAO(conSet.getConnection());
                OutputStream out = docDao.createDocumentFile(this.event.setResultDocument(), pattern.getDocumentTitle());
                out.write(result.toByteArray());
                out.flush();
                out.close();
            } else {
                this.event.setResultBytes(result.toByteArray());
            }
        }
        catch (Exception ex) {
            throw new BGException(ex);
        }
    }

    private Pair<Document, String> processToDocument(int objectId) throws Exception {
        Pair<Document, String> result = new Pair<Document, String>();
        result.setFirst(XMLUtils.newDocument());
        Pattern pattern = this.event.getPattern();
        if (!Utils.notBlankString(pattern.getJsp())) {
            throw new BGException("JSP for pattern is not defined.", new Object[0]);
        }
        Element dataElement = XMLUtils.newElement((Document)result.getFirst(), "data");
        ByteArrayOutputStream bos = new ByteArrayOutputStream(200);
        ServletResponseInterceptor resp = new ServletResponseInterceptor(this.event.getForm().getHttpResponse(), bos);
        HttpServletRequest req = this.event.getForm().getHttpRequest();
        req.setAttribute("event", (Object)this.event);
        req.setAttribute("objectId", (Object)objectId);
        req.setAttribute("conSlave", (Object)this.conSet.getSlaveConnection());
        req.setAttribute("field", (Object)new FieldSetter(dataElement));
        req.getRequestDispatcher(pattern.getJsp()).include((ServletRequest)req, (ServletResponse)resp);
        resp.flush();
        result.setSecond(new String(bos.toByteArray(), StandardCharsets.UTF_8));
        return result;
    }

    public static final class FieldSetter {
        private final Element dataNode;

        private FieldSetter(Element rootNode) {
            this.dataNode = rootNode;
        }

        public void set(String field, String value) {
            Element fieldEl = XMLUtils.newElement(this.dataNode, "field");
            fieldEl.setAttribute("name", field);
            XMLUtils.createTextNode(fieldEl, value);
        }
    }
}

