/*
 * Decompiled with CFR 0.152.
 */
package ru.bgcrm.plugin.bgbilling.proto.dao;

import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonNode;
import java.util.Date;
import java.util.List;
import java.util.Set;
import ru.bgcrm.model.user.User;
import ru.bgcrm.plugin.bgbilling.DBInfo;
import ru.bgcrm.plugin.bgbilling.RequestJsonRpc;
import ru.bgcrm.plugin.bgbilling.proto.dao.BillingModuleDAO;
import ru.bgcrm.plugin.bgbilling.proto.model.inet.IpResourceRange;
import ru.bgcrm.util.inet.IPUtils;

public class ResourceDAO
extends BillingModuleDAO {
    private static final String RESOURCE_MODULE_ID = "ru.bitel.oss.systems.inventory.resource";

    public ResourceDAO(User user, DBInfo dbInfo, int moduleId) {
        super(user, dbInfo, moduleId);
    }

    public ResourceDAO(User user, String billingId, int moduleId) {
        super(user, billingId, moduleId);
    }

    public List<IpResourceRange> getFreeIpResourceRangeList(Set<Integer> categoryIds, int range, int max) {
        RequestJsonRpc req = new RequestJsonRpc(RESOURCE_MODULE_ID, this.moduleId, "ResourceService", "freeIpResourceRangeList");
        Date now = new Date();
        req.setParam("ipResourceCategoryIds", categoryIds);
        req.setParam("range", range);
        req.setParam("max", max);
        req.setParam("dateFrom", now);
        req.setParam("dateTo", now);
        JsonNode ret = this.transferData.postDataReturn(req, this.user);
        List result = (List)this.readJsonValue(ret.traverse(), (JavaType)this.jsonTypeFactory.constructCollectionType(List.class, IpResourceRange.class));
        for (IpResourceRange r : result) {
            r.setFrom(IPUtils.base64ToString(r.getFrom()));
            r.setTo(IPUtils.base64ToString(r.getTo()));
        }
        return result;
    }

    public Integer getFreeVlan(Set<Integer> vlanResourceCategoryIds, Date dateFrom, Date dateTo) {
        RequestJsonRpc req = new RequestJsonRpc(RESOURCE_MODULE_ID, this.moduleId, "ResourceService", "freeVlan");
        Date now = new Date();
        req.setParam("vlanResourceCategoryIds", vlanResourceCategoryIds);
        req.setParam("dateFrom", dateFrom);
        req.setParam("dateTo", dateTo);
        JsonNode response = this.transferData.postDataReturn(req, this.user);
        return (Integer)this.jsonMapper.convertValue((Object)response, Integer.class);
    }
}

