/*
 * Decompiled with CFR 0.152.
 */
package ru.bgcrm.plugin.bgbilling.proto.dao;

import java.util.ArrayList;
import java.util.List;
import org.bgerp.app.exception.BGException;
import org.bgerp.model.base.IdTitle;
import org.bgerp.util.xml.XMLUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import ru.bgcrm.model.Pair;
import ru.bgcrm.model.user.User;
import ru.bgcrm.plugin.bgbilling.DBInfo;
import ru.bgcrm.plugin.bgbilling.Request;
import ru.bgcrm.plugin.bgbilling.dao.BillingDAO;
import ru.bgcrm.plugin.bgbilling.proto.model.ContractService;
import ru.bgcrm.util.TimeUtils;
import ru.bgcrm.util.Utils;

public class ContractServiceDAO
extends BillingDAO {
    private static final String CONTRACT_MODULE_ID = "contract";

    public ContractServiceDAO(User user, DBInfo dbInfo) throws BGException {
        super(user, dbInfo);
    }

    public ContractServiceDAO(User user, String billingId) throws BGException {
        super(user, billingId);
    }

    public List<ContractService> getContractServiceList(int contractId, int moduleId) throws BGException {
        ArrayList<ContractService> result = new ArrayList<ContractService>();
        Request req = new Request();
        req.setModule(CONTRACT_MODULE_ID);
        req.setAction("ContractServices");
        req.setModuleID(moduleId);
        req.setContractId(contractId);
        Document doc = this.transferData.postData(req, this.user);
        for (Element el : XMLUtils.selectElements(doc, "/data/table/data/row")) {
            ContractService service = new ContractService();
            service.setId(Utils.parseInt(el.getAttribute("f0")));
            service.setServiceTitle(el.getAttribute("f1"));
            service.setServiceId(Utils.parseInt(el.getAttribute("f4")));
            TimeUtils.parsePeriod(el.getAttribute("f2"), service);
            service.setComment(el.getAttribute("f3"));
            result.add(service);
        }
        return result;
    }

    public Pair<ContractService, List<IdTitle>> getContractService(int contractId, int moduleId, int id, boolean onlyUsing) throws BGException {
        ContractService service = null;
        ArrayList<IdTitle> serviceList = new ArrayList<IdTitle>();
        Request req = new Request();
        req.setModule(CONTRACT_MODULE_ID);
        req.setAction("ContractService");
        req.setModuleID(moduleId);
        req.setContractId(contractId);
        req.setAttribute("id", id);
        req.setAttribute("onlyUsing", onlyUsing);
        Document doc = this.transferData.postData(req, this.user);
        Element serviceEl = XMLUtils.selectElement(doc, "/data/service");
        if (serviceEl != null) {
            service = new ContractService();
            service.setId(id);
            service.setContractId(contractId);
            service.setServiceId(Utils.parseInt(serviceEl.getAttribute("sid")));
            service.setDateFrom(TimeUtils.parse(serviceEl.getAttribute("date1"), "dd.MM.yyyy"));
            service.setDateTo(TimeUtils.parse(serviceEl.getAttribute("date2"), "dd.MM.yyyy"));
            service.setComment(serviceEl.getAttribute("comment"));
        }
        for (Element item : XMLUtils.selectElements(doc, "/data/tree/module/service")) {
            serviceList.add(new IdTitle(item));
        }
        return new Pair<ContractService, List<IdTitle>>(service, serviceList);
    }

    public void updateContractService(ContractService service) throws BGException {
        Request req = new Request();
        req.setModule(CONTRACT_MODULE_ID);
        req.setAction("UpdateContractService");
        req.setAttribute("id", service.getId());
        req.setContractId(service.getContractId());
        req.setAttribute("date1", TimeUtils.format(service.getDateFrom(), "dd.MM.yyyy"));
        req.setAttribute("date2", TimeUtils.format(service.getDateTo(), "dd.MM.yyyy"));
        req.setAttribute("comment", service.getComment());
        this.transferData.postData(req, this.user);
    }

    public void deleteContractService(int contractId, int id) throws BGException {
        Request req = new Request();
        req.setModule(CONTRACT_MODULE_ID);
        req.setAction("DeleteContractService");
        req.setAttribute("id", id);
        req.setContractId(contractId);
        this.transferData.postData(req, this.user);
    }
}

