/*
 * Decompiled with CFR 0.152.
 */
package ru.bgcrm.model;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.bgerp.app.cfg.ConfigMap;
import org.bgerp.app.cfg.Preferences;
import org.bgerp.app.exception.BGMessageException;
import org.bgerp.util.Log;
import ru.bgcrm.dao.ConfigDAO;
import ru.bgcrm.model.LastModify;
import ru.bgcrm.model.LastModifySupport;
import ru.bgcrm.plugin.Plugin;
import ru.bgcrm.plugin.PluginManager;
import ru.bgcrm.util.Utils;

public class Config
implements LastModifySupport {
    private static final Log log = Log.getLog();
    public static final String INCLUDE_PREFIX = "include.";
    private int id = -1;
    @Deprecated
    private int userId = -1;
    private boolean active = false;
    @Deprecated
    private Date date;
    private String data;
    private String title;
    private int parentId;
    private List<Config> includedList;
    private ConfigMap valueMap = new Preferences();
    private LastModify lastModify = new LastModify();

    public int getId() {
        return this.id;
    }

    public void setId(int id) {
        this.id = id;
    }

    @Deprecated
    public int getUserId() {
        return this.userId;
    }

    @Deprecated
    public void setUserId(int userId) {
        this.userId = userId;
    }

    public boolean isActive() {
        return this.active;
    }

    public void setActive(boolean active) {
        this.active = active;
    }

    @Deprecated
    public Date getDate() {
        return this.date;
    }

    @Deprecated
    public void setDate(Date date) {
        this.date = date;
    }

    public String getData() {
        return this.data;
    }

    public void setData(String data) {
        this.data = data;
        this.valueMap = new Preferences(data);
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public int getParentId() {
        return this.parentId;
    }

    public void setParentId(int parentId) {
        this.parentId = parentId;
    }

    public void addIncluded(Config included) {
        if (this.includedList == null) {
            this.includedList = new ArrayList<Config>();
        }
        this.includedList.add(included);
        this.includedList.sort((c1, c2) -> c1.title.compareTo(c2.title));
    }

    public List<Config> getIncludedList() {
        return this.includedList;
    }

    public ConfigMap getValueMap() {
        return this.valueMap;
    }

    @Override
    public LastModify getLastModify() {
        return this.lastModify;
    }

    @Override
    public void setLastModify(LastModify lastModify) {
        this.lastModify = lastModify;
    }

    public String getEnabledPluginsTitles() {
        Preferences config = new Preferences(this.data);
        return PluginManager.getInstance().getFullSortedPluginList().stream().filter(p -> !p.isSystem() && p.isEnabled(config, "0")).map(Plugin::getTitle).collect(Collectors.joining(", "));
    }

    public static Iterable<String> getIncludes(ConfigDAO configDao, ConfigMap data, boolean validate) throws BGMessageException, SQLException {
        ArrayList<String> result = new ArrayList<String>();
        for (Map.Entry<String, String> me : data.sub(INCLUDE_PREFIX).entrySet()) {
            int configId = Utils.parseInt(me.getKey());
            boolean load = Utils.parseBoolean(me.getValue());
            if (!load || configId <= 0) continue;
            Config config = configDao.getGlobalConfig(configId);
            if (config == null) {
                String message = "Not found included config: " + configId;
                if (validate) {
                    throw new BGMessageException(message, new Object[0]);
                }
                log.error(message, new Object[0]);
                continue;
            }
            result.add(config.getData());
        }
        return result;
    }
}

