/*
 * Decompiled with CFR 0.152.
 */
package org.bgerp.util;

import com.google.common.collect.Lists;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Level;
import org.apache.log4j.Priority;
import org.bgerp.app.exception.BGException;
import org.bgerp.util.Log;
import org.bgerp.util.log.SessionLogAppender;
import org.bgerp.util.log.TrackedSession;

public class RuntimeRunner {
    private static final Log log = Log.getLog();
    private final String[] commands;
    private File directory;
    private volatile StreamGobbler stderr;
    private volatile StreamGobbler stdout;

    public RuntimeRunner(String ... commands) {
        this.commands = commands;
    }

    public RuntimeRunner directory(File value) {
        this.directory = value;
        return this;
    }

    public List<String> stdErr() {
        return this.stderr.getOutput();
    }

    public List<String> stdOut() {
        return this.stdout.getOutput();
    }

    public RuntimeRunner run() throws IOException, InterruptedException {
        int result = this.runSafe();
        if (result != 0) {
            throw new BGException("Process exit code: {}", result);
        }
        return this;
    }

    public int runSafe() throws IOException, InterruptedException {
        ProcessBuilder processBuilder = new ProcessBuilder(new String[0]);
        if (this.directory != null) {
            processBuilder.directory(this.directory);
        }
        ArrayList commands = Lists.newArrayList((Object[])this.commands);
        log.info("Running: {}", commands);
        Process proc = processBuilder.command(commands).start();
        this.stderr = new StreamGobbler(proc.getErrorStream(), true, SessionLogAppender.getTracked());
        this.stderr.start();
        this.stdout = new StreamGobbler(proc.getInputStream(), false, SessionLogAppender.getTracked());
        this.stdout.start();
        this.stderr.join();
        this.stdout.join();
        return proc.waitFor();
    }

    private static class StreamGobbler
    extends Thread {
        private final InputStream is;
        private final Priority logLevel;
        private final TrackedSession session;
        private final List<String> output = new ArrayList<String>();

        private StreamGobbler(InputStream is, boolean error, TrackedSession session) {
            this.is = is;
            this.logLevel = error ? Level.ERROR : Level.INFO;
            this.session = session;
            this.setName(Thread.currentThread().getName() + "-" + (error ? "stderr" : "stdout"));
        }

        private List<String> getOutput() {
            return this.output;
        }

        @Override
        public void run() {
            if (this.session != null) {
                SessionLogAppender.track(this.session.getSession(), false);
            }
            try {
                InputStreamReader isr = new InputStreamReader(this.is);
                BufferedReader br = new BufferedReader(isr);
                String line = null;
                while ((line = br.readLine()) != null) {
                    this.output.add(line);
                    log.log(this.logLevel, line);
                }
            }
            catch (IOException e) {
                log.error(e);
            }
        }
    }
}

