/*
 * Decompiled with CFR 0.152.
 */
package org.bgerp.plugin.pln.sla.config;

import java.sql.SQLException;
import java.time.Duration;
import java.time.Instant;
import java.util.Collections;
import java.util.Date;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import org.apache.commons.lang3.StringUtils;
import org.bgerp.app.cfg.Config;
import org.bgerp.app.cfg.ConfigMap;
import org.bgerp.dao.param.ParamValueDAO;
import org.bgerp.plugin.pln.sla.config.Config;
import org.bgerp.util.Log;
import ru.bgcrm.util.Utils;
import ru.bgcrm.util.sql.ConnectionSet;

public class ProcessTypeConfig
extends org.bgerp.app.cfg.Config {
    private static final Log log = Log.getLog();
    private final Duration closeBefore;
    private final Duration updateBefore;
    private final SortedMap<Long, String> leftMinutesColors;

    protected ProcessTypeConfig(ConfigMap config) throws Config.InitStopException {
        super(null);
        ConfigMap subConfig = config.sub("sla:");
        this.closeBefore = this.loadDurationInMin(subConfig, "close.before.minutes");
        this.updateBefore = this.loadDurationInMin(subConfig, "update.before.minutes");
        this.leftMinutesColors = this.loadLeftMinutesColors(subConfig);
        log.debug("closeBefore: {}, updateBefore: {}, config: {}", this.closeBefore, this.updateBefore, config);
        this.initWhen(this.closeBefore != null || this.updateBefore != null);
    }

    private Duration loadDurationInMin(ConfigMap config, String key) {
        int value = config.getInt(key);
        return value > 0 ? Duration.ofMinutes(value) : null;
    }

    private SortedMap<Long, String> loadLeftMinutesColors(ConfigMap config) {
        TreeMap<Long, String> result = new TreeMap<Long, String>();
        for (Map.Entry<String, String> me : config.sub("color.").entrySet()) {
            result.put(Utils.parseLong(me.getValue()), StringUtils.substringBefore((String)me.getKey(), (String)"."));
        }
        return Collections.unmodifiableSortedMap(result);
    }

    public SortedMap<Long, String> getLeftMinutesColors() {
        return this.leftMinutesColors;
    }

    public void processCreated(ConnectionSet conSet, Config config, int processId) {
        try {
            ParamValueDAO dao = new ParamValueDAO(conSet.getConnection());
            if (this.closeBefore != null && config.getParamCloseBeforeId() > 0) {
                dao.updateParamDateTime(processId, config.getParamCloseBeforeId(), Date.from(Instant.now().plus(this.closeBefore)));
            }
            if (this.updateBefore != null && config.getParamUpdateBeforeId() > 0) {
                dao.updateParamDateTime(processId, config.getParamUpdateBeforeId(), Date.from(Instant.now().plus(this.updateBefore)));
            }
        }
        catch (SQLException e) {
            log.error(e);
        }
    }

    public void processUpdated(ConnectionSet conSet, Config config, int processId) {
        try {
            ParamValueDAO dao = new ParamValueDAO(conSet.getConnection());
            if (this.updateBefore != null && config.getParamUpdateBeforeId() > 0) {
                dao.updateParamDateTime(processId, config.getParamUpdateBeforeId(), Date.from(Instant.now().plus(this.updateBefore)));
            }
        }
        catch (SQLException e) {
            log.error(e);
        }
    }
}

