/*
 * Decompiled with CFR 0.152.
 */
package org.bgerp.plugin.bil.subscription.action;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.sql.Connection;
import java.sql.Date;
import java.sql.ResultSet;
import java.time.temporal.ChronoUnit;
import java.util.TreeMap;
import java.util.TreeSet;
import org.apache.struts.action.ActionForward;
import org.bgerp.app.cfg.Setup;
import org.bgerp.app.l10n.Localization;
import org.bgerp.plugin.bil.subscription.Config;
import org.bgerp.plugin.bil.subscription.model.Subscription;
import org.bgerp.plugin.report.action.ReportActionBase;
import org.bgerp.plugin.report.model.Column;
import org.bgerp.plugin.report.model.Columns;
import org.bgerp.plugin.report.model.Data;
import org.bgerp.plugin.report.model.Record;
import org.bgerp.util.TimeConvert;
import org.bgerp.util.sql.PreparedQuery;
import ru.bgcrm.servlet.ActionServlet;
import ru.bgcrm.struts.form.DynActionForm;
import ru.bgcrm.util.TimeUtils;
import ru.bgcrm.util.Utils;
import ru.bgcrm.util.sql.ConnectionSet;

@ActionServlet.Action(path="/user/plugin/report/plugin/subscription/payment")
public class ReportPaymentAction
extends ReportActionBase {
    private static final Columns COLUMNS = new Columns(new Column.ColumnInteger("subscription_id", null, null), new Column.ColumnInteger("process_id", null, "Subscription Process"), new Column.ColumnInteger("customer_id", null, null), new Column.ColumnString("customer_title", null, "Customer"), new Column.ColumnDecimal("payment_amount", null, "Amount"), new Column.ColumnInteger("months", null, "Months"), new Column.ColumnDecimal("service_cost", null, "Service Cost"), new Column.ColumnInteger("service_consultant_user_id", null, null), new Column.ColumnString("service_consultant_user_title", null, "Service Consultant"), new Column.ColumnDecimal("discount", null, "Discount"), new Column.ColumnDecimal("owners_amount", null, "Owners Amount"), new Column.ColumnInteger("product_id", null, null), new Column.ColumnString("product_description", null, "Product Process"), new Column.ColumnInteger("product_owner_user_id", null, null), new Column.ColumnString("product_owner_user_title", null, "Owner"), new Column.ColumnDecimal("product_cost", null, "Product Cost"), new Column.ColumnDecimal("product_cost_part", null, "Product Cost Part"));
    private static final Selector SELECTOR = new Selector();

    @Override
    public ActionForward unspecified(DynActionForm form, ConnectionSet conSet) throws Exception {
        return super.unspecified(form, conSet);
    }

    @Override
    public String getTitle() {
        return Localization.getLocalizer(Localization.getLang(), "subscription").l("Subscription Payments", new Object[0]);
    }

    @Override
    protected String getHref() {
        return "report/subscription/payment";
    }

    @Override
    protected String getJsp() {
        return "/WEB-INF/jspf/user/plugin/subscription/report/payment.jsp";
    }

    @Override
    public Columns getColumns() {
        return COLUMNS;
    }

    @Override
    protected Selector getSelector() {
        return SELECTOR;
    }

    static class Selector
    extends ReportActionBase.Selector {
        Selector() {
        }

        @Override
        protected void select(ConnectionSet conSet, Data data) throws Exception {
            Connection con = conSet.getSlaveConnection();
            DynActionForm form = data.getForm();
            Config config = Setup.getSetup().getConfig(Config.class);
            form.setRequestAttribute("config", config);
            java.util.Date date = form.getParamDate("dateFrom");
            if (date == null) {
                form.setParam("dateFrom", TimeUtils.format(TimeUtils.getPrevMonth(), "ymd"));
                return;
            }
            int userId = form.getUserId();
            BigDecimal incomingTaxPercent = null;
            TreeMap subscriptionUserAmounts = new TreeMap();
            form.setResponseData("subscriptionUserAmounts", subscriptionUserAmounts);
            for (Subscription subscription : config.getSubscriptions()) {
                TreeMap<Integer, BigDecimal> userAmounts = new TreeMap<Integer, BigDecimal>();
                TreeSet<Integer> serviceCostAddedProcessIds = new TreeSet<Integer>();
                try (PreparedQuery pq = this.query(con, config, subscription, date, userId);){
                    ResultSet rs = pq.executeQuery();
                    while (rs.next()) {
                        BigDecimal amount = rs.getBigDecimal("invoice.amount");
                        Date dateFrom = rs.getDate("invoice.date_from");
                        java.util.Date dateTo = Utils.maskNull(rs.getDate("invoice.date_to"), dateFrom);
                        BigDecimal months = BigDecimal.valueOf(ChronoUnit.MONTHS.between(TimeConvert.toYearMonth(dateFrom), TimeConvert.toYearMonth(dateTo)) + 1L);
                        int subscriptionProcessId = rs.getInt("invoice.process_id");
                        if (rs.isFirst() && incomingTaxPercent == null) {
                            incomingTaxPercent = rs.getBigDecimal("invoice_tax.value");
                            form.setResponseData("incomingTaxPercent", incomingTaxPercent);
                        }
                        BigDecimal discount = Utils.maskNullDecimal(rs.getBigDecimal("discount.value")).multiply(months);
                        BigDecimal serviceCost = Utils.maskNullDecimal(rs.getBigDecimal("service_cost.value")).multiply(months);
                        int serviceConsultantId = rs.getInt("service_consultant.user_id");
                        BigDecimal productCost = Utils.maskNullDecimal(rs.getBigDecimal("product_cost.count")).multiply(months);
                        int productOwnerId = rs.getInt("product_owner.user_id");
                        Record record = data.addRecord();
                        record.add(subscription.getId());
                        record.add(subscriptionProcessId);
                        record.add(rs.getInt("invoice_customer.object_id"));
                        record.add(rs.getString("invoice_customer.object_title"));
                        record.add(amount);
                        record.add(months.intValue());
                        record.add(serviceCost);
                        record.add(serviceConsultantId);
                        record.add(null);
                        record.add(discount);
                        if (serviceCostAddedProcessIds.add(subscriptionProcessId)) {
                            BigDecimal userAmount = userAmounts.computeIfAbsent(serviceConsultantId, unused -> BigDecimal.ZERO).add(this.incomingTax(incomingTaxPercent, serviceCost));
                            userAmounts.put(serviceConsultantId, userAmount);
                        }
                        BigDecimal ownersAmount = amount.subtract(serviceCost);
                        record.add(ownersAmount);
                        record.add(rs.getInt("product.id"));
                        record.add(rs.getString("product.description"));
                        record.add(productOwnerId);
                        record.add(null);
                        record.add(productCost);
                        if (productOwnerId != userId) {
                            BigDecimal fullCost = ownersAmount.add(discount);
                            BigDecimal ownersAmountAfterTax = this.incomingTax(incomingTaxPercent, ownersAmount);
                            BigDecimal ownerPart = productCost.multiply(ownersAmountAfterTax).divide(fullCost, RoundingMode.HALF_UP).setScale(2, RoundingMode.HALF_UP);
                            record.add(ownerPart);
                            BigDecimal userAmount = userAmounts.computeIfAbsent(productOwnerId, unused -> BigDecimal.ZERO).add(ownerPart);
                            userAmounts.put(productOwnerId, userAmount);
                            continue;
                        }
                        record.add(null);
                    }
                }
                if (userAmounts.isEmpty()) continue;
                subscriptionUserAmounts.put(subscription.getId(), userAmounts);
            }
        }

        protected PreparedQuery query(Connection con, Config config, Subscription subscription, java.util.Date date, int userId) {
            PreparedQuery result = new PreparedQuery(con);
            result.addQuery("SELECT invoice.amount, invoice.process_id, invoice.date_from, invoice.date_to, invoice.payment_user_id, invoice_tax.value, invoice_customer.object_id, invoice_customer.object_title, discount.value, service_cost.value, service_consultant.user_id, product.id, product.description, product_owner.user_id, product_cost.count FROM  invoice AS invoice  LEFT JOIN  param_money AS invoice_tax ON invoice.payment_user_id=invoice_tax.id AND invoice_tax.param_id=? LEFT JOIN  process_link AS invoice_customer ON invoice.process_id=invoice_customer.process_id AND invoice_customer.object_type=? INNER JOIN  param_list AS subscription ON invoice.process_id=subscription.id AND subscription.param_id=? AND subscription.value=?");
            result.addInt(config.getParamUserIncomingTaxPercentId());
            result.addString("customer");
            result.addInt(config.getParamSubscriptionId());
            result.addInt(subscription.getId());
            result.addQuery(" INNER JOIN  param_list AS param_limit ON invoice.process_id=param_limit.id AND param_limit.param_id=? LEFT JOIN  param_money AS discount ON invoice.process_id=discount.id AND discount.param_id=? LEFT JOIN  param_money AS service_cost ON invoice.process_id=service_cost.id AND service_cost.param_id=? LEFT JOIN  process_executor AS service_consultant ON invoice.process_id=service_consultant.process_id AND service_consultant.role_id=0");
            result.addInt(config.getParamLimitId());
            result.addInt(config.getParamDiscountId());
            result.addInt(config.getParamServiceCostId());
            result.addQuery(" INNER JOIN  process_link AS subscription_product ON subscription_product.object_id=invoice.process_id AND subscription_product.object_type=? INNER JOIN  process AS product ON subscription_product.process_id=product.id LEFT JOIN  process_executor AS product_owner ON product.id=product_owner.process_id AND product_owner.role_id=1 INNER JOIN  param_listcount AS product_cost ON product.id=product_cost.id AND product_cost.param_id=? AND param_limit.value=product_cost.value");
            result.addString("processDepend");
            result.addInt(subscription.getParamLimitPriceId());
            result.addQuery(" WHERE ?<=invoice.payment_date AND invoice.payment_date<=?");
            result.addDate(date);
            result.addDate(TimeUtils.getEndMonth(date));
            if (userId > 0) {
                result.addQuery(" AND invoice.payment_user_id=?");
                result.addInt(userId);
            }
            result.addQuery(" ORDER BY invoice.payment_date");
            return result;
        }

        protected BigDecimal incomingTax(BigDecimal incomingTaxPercent, BigDecimal value) {
            if (incomingTaxPercent == null) {
                return value;
            }
            return value.multiply(BigDecimal.ONE.subtract(incomingTaxPercent.divide(new BigDecimal("100")))).setScale(2, RoundingMode.HALF_UP);
        }
    }
}

