/*
 * Decompiled with CFR 0.152.
 */
package org.bgerp;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.net.InetAddress;
import java.net.Socket;
import java.nio.charset.StandardCharsets;
import java.security.SecureRandom;
import java.security.cert.X509Certificate;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Executor;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSession;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import org.apache.catalina.LifecycleException;
import org.apache.catalina.Valve;
import org.apache.catalina.connector.Connector;
import org.apache.catalina.core.StandardContext;
import org.apache.catalina.startup.Tomcat;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.PropertyConfigurator;
import org.apache.tomcat.util.IntrospectionUtils;
import org.apache.tomcat.util.http.CookieProcessor;
import org.apache.tomcat.util.http.Rfc6265CookieProcessor;
import org.apache.tomcat.util.threads.TaskQueue;
import org.apache.tomcat.util.threads.TaskThreadFactory;
import org.apache.tomcat.util.threads.ThreadPoolExecutor;
import org.bgerp.app.cfg.Setup;
import org.bgerp.app.cfg.bean.Bean;
import org.bgerp.app.exception.alarm.AlarmSender;
import org.bgerp.app.exec.scheduler.Scheduler;
import org.bgerp.app.servlet.util.AccessLogValve;
import org.bgerp.custom.Custom;
import org.bgerp.util.Log;
import ru.bgcrm.plugin.PluginManager;
import ru.bgcrm.util.AdminPortListener;
import ru.bgcrm.util.Utils;

public class Server
extends Tomcat {
    private static final String TOMCAT_WORK_DIR = Utils.getTmpDir() + "/tomcat";
    public static final String WEBAPPS_DIR = "webapps";
    private final Log log = Log.getLog();
    private final Setup setup;

    private Server() {
        this.installTrustManager();
        this.setTomcatProperties();
        this.configureLogging();
        this.log.info("Starting with '{}.properties'..", Setup.getBundleName());
        this.log.info(AdminPortListener.getVersionInfo(), new Object[0]);
        this.setup = Setup.getSetup();
        try {
            this.checkDBConnectionOrExit();
            PluginManager.init();
            String catalinaHome = new File(".").getAbsolutePath();
            catalinaHome = catalinaHome.substring(0, catalinaHome.length() - 2);
            this.setBaseDir(catalinaHome);
            this.log.info("catalinaHome: {}; hostname: {}", catalinaHome, this.hostname);
            File workDir = new File(TOMCAT_WORK_DIR);
            if (!workDir.exists()) {
                this.log.info("Creating missing directory: {}", TOMCAT_WORK_DIR);
                workDir.mkdir();
            }
            this.log.info("Cleaning up directory: {}", TOMCAT_WORK_DIR);
            FileUtils.cleanDirectory((File)workDir);
            this.configureContext(catalinaHome);
            this.startServer();
            new AdminPortListener(this.setup.getInt("server.port.admin", 8005));
            this.warnOnOldPath("dyn");
            this.warnOnOldPath("work");
            this.doOnStart();
            Scheduler.getInstance();
            AlarmSender.init(this.setup);
        }
        catch (Exception e) {
            this.log.error(e);
            System.exit(1);
        }
    }

    private void warnOnOldPath(String name) {
        if (new File(name).exists()) {
            this.log.warn("Directory '{}' is no longer used and can be deleted.", name);
        }
    }

    private void configureLogging() {
        PropertyConfigurator.configureAndWatch((String)"log4j.properties");
        Logger.getLogger("").setLevel(Level.WARNING);
    }

    private void setTomcatProperties() {
        System.setProperty("org.apache.catalina.core.ApplicationHttpRequest.INHERIT_REQUEST_PARAMETERS", "false");
        System.setProperty("org.apache.jasper.runtime.BodyContentImpl.LIMIT_BUFFER", "true");
    }

    private void configureContext(String catalinaHome) {
        String customJarMarker = this.setup.get("custom.jar.marker", "custom");
        StandardContext context = (StandardContext)this.addWebapp("", catalinaHome + "/webapps");
        context.setReloadable(false);
        context.setWorkDir(TOMCAT_WORK_DIR);
        context.setUseNaming(false);
        Rfc6265CookieProcessor cookieProcessor = new Rfc6265CookieProcessor();
        cookieProcessor.setSameSiteCookies("strict");
        context.setCookieProcessor((CookieProcessor)cookieProcessor);
        context.getJarScanner().setJarScanFilter((type, name) -> {
            boolean result = name.contains("struts") || name.contains("tag") || name.contains(customJarMarker);
            this.log.debug("Scan type: {}, name: {} => {}", type, name, result);
            return result;
        });
        context.addValve((Valve)new AccessLogValve());
        Custom.INSTANCE.webapps(catalinaHome, context);
    }

    private void startServer() throws LifecycleException {
        int port = this.setup.getInt("server.port.http", 8080);
        String address = this.setup.get("server.listen.address", null);
        this.log.info("Starting server HTTP port: {}; listen address: {}", port, address);
        Connector connector = this.getConnector();
        if (StringUtils.isNotBlank((CharSequence)address)) {
            IntrospectionUtils.setProperty((Object)connector, (String)"address", (String)address);
        }
        connector.setPort(port);
        connector.setEnableLookups(false);
        connector.setURIEncoding(StandardCharsets.UTF_8.name());
        connector.setUseBodyEncodingForURI(true);
        connector.setMaxPostSize(this.setup.getInt("max.post.size", 10000000));
        connector.setMaxSavePostSize(1000000);
        TaskQueue queue = new TaskQueue();
        TaskThreadFactory tf = new TaskThreadFactory("http-", true, 5);
        ThreadPoolExecutor executor = new ThreadPoolExecutor(10, this.setup.getInt("connector.http.threads.max", 25), 60L, TimeUnit.SECONDS, (BlockingQueue)queue, (ThreadFactory)tf);
        queue.setParent(executor);
        connector.getProtocolHandler().setExecutor((Executor)executor);
        this.start();
        System.out.println(Log.format("Server URL: 'http://{}:{}', see logs in 'log' directory", this.hostname, port));
    }

    private void doOnStart() {
        for (String className : Utils.toSet(this.setup.get("runOnStart"))) {
            this.log.info("Run class on start: " + className, new Object[0]);
            try {
                ((Runnable)Bean.newInstance(className)).run();
            }
            catch (Exception e) {
                this.log.error(e.getMessage(), e);
            }
        }
    }

    private void checkDBConnectionOrExit() {
        try (Connection con = this.setup.getDBConnectionFromPool();){
            if (con == null) {
                throw new SQLException("SQL connection was null");
            }
        }
        catch (SQLException e) {
            this.log.error(e);
            Utils.errorAndExit(2, "Problem with getting SQL connection, stopping. See log for details.");
        }
    }

    private void installTrustManager() {
        TrustManager[] trustAllCerts = new TrustManager[]{new X509TrustManager(this){

            @Override
            public X509Certificate[] getAcceptedIssuers() {
                return null;
            }

            @Override
            public void checkClientTrusted(X509Certificate[] certs, String authType) {
            }

            @Override
            public void checkServerTrusted(X509Certificate[] certs, String authType) {
            }
        }};
        HostnameVerifier hv = new HostnameVerifier(this){

            @Override
            public boolean verify(String urlHostName, SSLSession session) {
                if (!urlHostName.equalsIgnoreCase(session.getPeerHost())) {
                    System.out.println("Warning: URL host '" + urlHostName + "' is different to SSLSession host '" + session.getPeerHost() + "'.");
                }
                return true;
            }
        };
        try {
            SSLContext sc = SSLContext.getInstance("SSL");
            sc.init(null, trustAllCerts, new SecureRandom());
            HttpsURLConnection.setDefaultSSLSocketFactory(sc.getSocketFactory());
            HttpsURLConnection.setDefaultHostnameVerifier(hv);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void main(String[] args) {
        int adminPort = new Setup(false).getInt("server.port.admin", 8005);
        if (args.length > 0) {
            if (args[0].trim().equals("start")) {
                new Server();
            } else {
                Server.executeCommand(args, adminPort, 1);
            }
        } else {
            Server.showHelp();
        }
    }

    private static void executeCommand(String[] args, int port, int cnt) {
        block5: {
            try {
                String command = "";
                if (args.length < 1) break block5;
                command = args[0];
                String result = "";
                Socket socket = null;
                try {
                    socket = new Socket(InetAddress.getByName("127.0.0.1"), port);
                    BufferedReader in = new BufferedReader(new InputStreamReader(socket.getInputStream()));
                    PrintWriter out = new PrintWriter((Writer)new BufferedWriter(new OutputStreamWriter(socket.getOutputStream())), true);
                    out.println(command);
                    result = in.readLine().replace('$', '\n');
                    socket.close();
                    System.out.println(result);
                    if ("Scheduler has running tasks, need wait to stop.".equals(result)) {
                        Thread.sleep(5000L);
                        System.out.println("RETRY: " + cnt);
                        Server.executeCommand(args, port, ++cnt);
                    }
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                    Utils.errorAndExit(1, ex.getMessage());
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
                Utils.errorAndExit(1, ex.getMessage());
            }
        }
    }

    private static void showHelp() {
        StringBuffer sb = new StringBuffer();
        sb.append("\nUsage: [start|stop|status|help]");
        sb.append("\nParameters:");
        sb.append("\n\t help                       - show this help");
        sb.append("\n\t start                      - starting");
        sb.append("\n\t stop                       - stopping");
        sb.append("\n\t status                     - show status");
        sb.append("\n\t gc                         - force Garbage Collector");
        sb.append("\n\nExample: crm.sh start");
        sb.append("\nExample: crm.sh status");
        System.out.println(sb.toString());
    }
}

