/*
 * Decompiled with CFR 0.152.
 */
package ru.bgcrm.model.process.queue.config;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.bgerp.app.cfg.Config;
import org.bgerp.app.cfg.ConfigMap;
import org.bgerp.app.cfg.Preferences;
import org.bgerp.model.base.IdTitle;
import ru.bgcrm.util.Utils;

public class SavedFiltersConfig
extends Config {
    private Map<Integer, List<SavedFilterSet>> queueSavedFilterSetsMap = new HashMap<Integer, List<SavedFilterSet>>();
    private Map<Integer, SavedFilterSet> savedFilterSetMap = new HashMap<Integer, SavedFilterSet>();
    private int maxId;
    private static final String QUEUE_SAVED_FILTER_SET_PREFIX = "queueSavedFilterSet.";
    public static final String QUEUE_CURRENT_SAVED_FILTER_SET_PREFIX = "queueCurrentSavedFilterSet.";
    private static final String QUEUE_SAVED_FILTER_SET_ORDER = "queueSavedFilterSetOrder.";

    public SavedFiltersConfig(ConfigMap config) {
        super(null);
        for (Map.Entry<Integer, ConfigMap> entry : config.subIndexed(QUEUE_SAVED_FILTER_SET_PREFIX).entrySet()) {
            int id = entry.getKey();
            SavedFilterSet set = new SavedFilterSet(id, entry.getValue());
            if (id <= 0 || set.getQueueId() <= 0 || Utils.isBlankString(set.getUrl()) || Utils.isBlankString(set.getTitle())) continue;
            this.getQueueSetList(set.getQueueId()).add(set);
            this.savedFilterSetMap.put(id, set);
            this.maxId = id;
        }
        for (Map.Entry<Integer, Object> entry : this.queueSavedFilterSetsMap.entrySet()) {
            int queueId = entry.getKey();
            List sets = (List)entry.getValue();
            List<Integer> order = Utils.toIntegerList(config.get(QUEUE_SAVED_FILTER_SET_ORDER + queueId));
            sets.sort((s1, s2) -> order.indexOf(s1.getId()) - order.indexOf(s2.getId()));
        }
    }

    public Map<Integer, SavedFilterSet> getTopFilters() {
        HashMap<Integer, SavedFilterSet> result = new HashMap<Integer, SavedFilterSet>();
        this.savedFilterSetMap.values().stream().filter(SavedFilterSet::isStatusCounterOnPanel).forEach(f -> result.put(f.getId(), (SavedFilterSet)f));
        return result;
    }

    public Map<Integer, List<SavedFilterSet>> getQueueSavedFilterSetsMap() {
        return this.queueSavedFilterSetsMap;
    }

    public Map<Integer, SavedFilterSet> getSavedFilterSetMap() {
        return this.savedFilterSetMap;
    }

    private List<SavedFilterSet> getQueueSetList(int queueId) {
        List<SavedFilterSet> setList = this.queueSavedFilterSetsMap.get(queueId);
        if (setList == null) {
            setList = new ArrayList<SavedFilterSet>();
            this.queueSavedFilterSetsMap.put(queueId, setList);
        }
        return setList;
    }

    public void reorderSavedFilterSets(int queueId, List<Integer> order) {
        List<SavedFilterSet> sets = this.queueSavedFilterSetsMap.get(queueId);
        if (sets != null) {
            sets.sort((s1, s2) -> order.indexOf(s1.getId()) - order.indexOf(s2.getId()));
        }
    }

    public void removeSavedFilterSet(int queueId, int id) {
        List<SavedFilterSet> setList = this.queueSavedFilterSetsMap.get(queueId);
        if (setList == null) {
            return;
        }
        SavedFilterSet savedSet = null;
        for (SavedFilterSet set : setList) {
            if (set.getId() != id) continue;
            savedSet = set;
            break;
        }
        if (savedSet != null) {
            setList.remove(savedSet);
        }
    }

    public int addSavedFilterSet(int queueId, String title, String url) {
        this.getQueueSetList(queueId).add(new SavedFilterSet(queueId, ++this.maxId, title, url));
        return this.maxId;
    }

    public void setRareStatus(int queueId, int filterId, Boolean value) {
        List<SavedFilterSet> filterList = this.getQueueSetList(queueId);
        for (SavedFilterSet filter : filterList) {
            if (filter.getId() != filterId) continue;
            filter.setRare(value);
        }
    }

    public void setStatusCounterOnPanel(int queueId, int filterId, String color, Boolean value, String title, String queueName) {
        List<SavedFilterSet> filterList = this.getQueueSetList(queueId);
        for (SavedFilterSet filter : filterList) {
            if (filter.getId() != filterId) continue;
            filter.setStatusCounterOnPanel(value);
            if (!value.booleanValue()) continue;
            filter.setColor(color);
            filter.setTitle(title);
            filter.setQueueName(queueName);
        }
    }

    public void updateConfig(Preferences userConfig) {
        userConfig.removeSub(QUEUE_SAVED_FILTER_SET_PREFIX);
        for (Map.Entry<Integer, List<SavedFilterSet>> me : this.queueSavedFilterSetsMap.entrySet()) {
            int queueId = me.getKey();
            List<SavedFilterSet> setList = me.getValue();
            userConfig.put(QUEUE_SAVED_FILTER_SET_ORDER + queueId, Utils.getObjectIds(setList));
            for (SavedFilterSet set : setList) {
                String setPrefix = QUEUE_SAVED_FILTER_SET_PREFIX + set.getId();
                userConfig.put(setPrefix + ".queueId", String.valueOf(set.getQueueId()));
                userConfig.put(setPrefix + ".title", set.getTitle());
                userConfig.put(setPrefix + ".queueName", set.getQueueName());
                userConfig.put(setPrefix + ".url", set.getUrl());
                userConfig.put(setPrefix + ".rare", String.valueOf(set.isRare()));
                userConfig.put(setPrefix + ".statusCounterOfPanel", String.valueOf(set.isStatusCounterOnPanel()));
                userConfig.put(setPrefix + ".color", set.getColor());
            }
        }
    }

    public static class SavedFilterSet
    extends IdTitle {
        private final int queueId;
        private final String url;
        private boolean rare;
        private boolean statusCounterOnPanel;
        private String color = "";
        private String queueName = "";

        private SavedFilterSet(int id, ConfigMap config) {
            this.id = id;
            this.queueId = config.getInt("queueId", 0);
            this.queueName = config.get("queueName") == null ? "" : config.get("queueName");
            this.title = config.get("title");
            this.url = config.get("url");
            this.rare = config.getBoolean("rare", false);
            this.statusCounterOnPanel = config.getBoolean("statusCounterOfPanel", false);
            this.color = config.get("color") == null ? "" : config.get("color");
        }

        private SavedFilterSet(int queueId, int id, String title, String url) {
            super(id, title);
            this.queueId = queueId;
            this.title = title;
            this.url = url;
        }

        public int getQueueId() {
            return this.queueId;
        }

        public String getUrl() {
            return this.url;
        }

        public void setRare(boolean value) {
            this.rare = value;
        }

        public boolean isRare() {
            return this.rare;
        }

        public void setStatusCounterOnPanel(boolean value) {
            this.statusCounterOnPanel = value;
        }

        public Boolean isStatusCounterOnPanel() {
            return this.statusCounterOnPanel;
        }

        public void setColor(String color) {
            this.color = color;
        }

        public String getColor() {
            return this.color;
        }

        public void setQueueName(String queueName) {
            this.queueName = queueName;
        }

        public String getQueueName() {
            return this.queueName;
        }
    }
}

