/*
 * Decompiled with CFR 0.152.
 */
package ru.bgcrm.dao.user;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.bgerp.app.exception.BGException;
import org.bgerp.model.Pageable;
import org.bgerp.util.sql.PreparedQuery;
import ru.bgcrm.dao.CommonDAO;
import ru.bgcrm.model.user.Group;
import ru.bgcrm.util.Utils;

public class UserGroupDAO
extends CommonDAO {
    public UserGroupDAO(Connection con) {
        super(con);
    }

    public void searchGroup(Pageable<Group> result, int parentId, String filter) throws SQLException {
        try (PreparedQuery pq = new PreparedQuery(this.con);){
            pq.addQuery("SELECT SQL_CALC_FOUND_ROWS g.*, ( SELECT GROUP_CONCAT(gp.permset_id SEPARATOR ',') FROM  user_group_permset  AS gp WHERE gp.group_id=g.id ORDER BY pos) AS permsets, ( SELECT GROUP_CONCAT(gq.queue_id SEPARATOR ',') FROM  user_group_queue  AS gq WHERE gq.group_id=g.id) AS queues  FROM  user_group_title  AS g  WHERE ");
            if (Utils.notBlankString(filter)) {
                pq.addQuery("(id LIKE ? OR title LIKE ? OR config LIKE ?)");
                pq.addString(filter).addString(filter).addString(filter);
            } else {
                pq.addQuery("parent_id=?");
                pq.addInt(parentId);
            }
            pq.addQuery(" ORDER BY title");
            pq.addQuery(result.getPage().getLimitSql());
            ResultSet rs = pq.executeQuery();
            while (rs.next()) {
                result.add(this.getFromRs(rs, true));
            }
            result.getPage().setRecordCount(pq.getPrepared());
        }
    }

    public List<Group> getGroupList() {
        ArrayList<Group> result = new ArrayList<Group>();
        try {
            String query = "SELECT * FROM  user_group_title  ORDER BY title";
            PreparedStatement ps = this.con.prepareStatement(query);
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                result.add(this.getFromRs(rs, false));
            }
            ps.close();
        }
        catch (SQLException ex) {
            throw new BGException(ex);
        }
        return result;
    }

    public Group getGroupById(int id) {
        Group result = null;
        try {
            String query = "SELECT * FROM  user_group_title  WHERE id=?";
            PreparedStatement ps = this.con.prepareStatement(query);
            ps.setInt(1, id);
            ResultSet rs = ps.executeQuery();
            if (rs.next()) {
                result = this.getFromRs(rs, false);
                result.setQueueIds(this.getGroupQueueIds(id));
                result.setPermsetIds(this.getGroupPermsetIds(id));
            }
            ps.close();
        }
        catch (SQLException ex) {
            throw new BGException(ex);
        }
        return result;
    }

    public void updateGroup(Group group) throws SQLException {
        String query = group.getId() <= 0 ? "INSERT INTO  user_group_title  (title, comment, parent_id, config) VALUES (?, ?, ?, ?)" : "UPDATE  user_group_title SET title=?, comment=?, parent_id=?, config=? WHERE id=?";
        try (PreparedQuery pq = new PreparedQuery(this.con, query);){
            pq.addObjects(group.getTitle(), group.getComment(), group.getParentId(), group.getConfig());
            if (group.getId() <= 0) {
                pq.executeInsert();
                group.setId(this.lastInsertId(pq.getPrepared()));
            } else {
                pq.addInt(group.getId());
                pq.executeUpdate();
            }
        }
        this.updateIds(" user_group_queue ", "group_id", "queue_id", group.getId(), group.getQueueIds());
        this.updateIds(" user_group_permset ", "group_id", "permset_id", "pos", group.getId(), group.getPermsetIds());
        this.setChildCount(group.getId(), 0);
    }

    public void deleteGroup(int id) throws SQLException {
        this.setChildCount(id, -1);
        this.deleteById(" user_group_title ", id);
    }

    public Set<Integer> getGroupQueueIds(int groupId) throws SQLException {
        return this.getIds(" user_group_queue ", "group_id", "queue_id", groupId);
    }

    public List<Integer> getGroupPermsetIds(int groupId) throws SQLException {
        return this.getIds(" user_group_permset ", "group_id", "permset_id", "pos", groupId);
    }

    public Map<Integer, List<Integer>> getAllGroupPermsetIds() throws SQLException {
        return this.getGroupedIds(" user_group_permset ", "group_id", "permset_id", "pos");
    }

    public Map<Integer, Set<Integer>> getAllGroupQueueIds() throws SQLException {
        return this.getGroupedIds(" user_group_queue ", "group_id", "queue_id");
    }

    private Group getFromRs(ResultSet rs, boolean loadQueuesAndPermsets) throws SQLException, BGException {
        Group result = new Group();
        result.setId(rs.getInt("id"));
        result.setTitle(rs.getString("title"));
        result.setComment(rs.getString("comment"));
        result.setParentId(rs.getInt("parent_id"));
        result.setChildCount(rs.getInt("child_count"));
        result.setConfig(rs.getString("config"));
        if (loadQueuesAndPermsets) {
            result.setPermsetIds(Utils.toIntegerList(rs.getString("permsets")));
            result.setQueueIds(Utils.toIntegerSet(rs.getString("queues")));
        }
        return result;
    }

    public boolean checkGroup(int id, int parentId, String title) throws SQLException {
        boolean result = false;
        StringBuilder query = new StringBuilder();
        query.append("SELECT ");
        query.append("COUNT(*)");
        query.append(" FROM ");
        query.append(" user_group_title ");
        query.append(" WHERE ");
        query.append("id !=? AND parent_id=? AND title=?");
        PreparedStatement ps = this.con.prepareStatement(query.toString());
        int index = 1;
        ps.setInt(index++, id);
        ps.setInt(index++, parentId);
        ps.setString(index++, title);
        ResultSet rs = ps.executeQuery();
        if (rs.next()) {
            result = rs.getInt(1) == 0;
        }
        ps.close();
        return result;
    }

    private void setChildCount(int chilsId, int countCorrect) throws SQLException {
        ResultSet rs = null;
        PreparedStatement ps = null;
        ps = this.con.prepareStatement("select count(*), t1.parent_id from  user_group_title  as t1 join  user_group_title  as t2 where t2.id = ? AND t1.parent_id = t2.parent_id");
        ps.setInt(1, chilsId);
        rs = ps.executeQuery();
        int count = 0;
        int parentId = 0;
        if (rs.next()) {
            count = rs.getInt(1);
            parentId = rs.getInt(2);
        }
        ps.close();
        int index = 1;
        PreparedStatement psUpdate = this.con.prepareStatement("UPDATE  user_group_title  SET child_count=? WHERE id=? ");
        psUpdate.setInt(index++, count += countCorrect);
        psUpdate.setInt(index++, parentId);
        psUpdate.executeUpdate();
        psUpdate.close();
    }
}

