/*
 * Decompiled with CFR 0.152.
 */
package org.bgerp.dao;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import javassist.NotFoundException;
import org.bgerp.model.DemoEntity;
import org.bgerp.model.Pageable;
import org.bgerp.util.sql.LikePattern;
import org.bgerp.util.sql.PreparedQuery;
import ru.bgcrm.dao.CommonDAO;
import ru.bgcrm.model.Page;
import ru.bgcrm.util.Utils;

public class DemoDAO
extends CommonDAO {
    public DemoDAO(Connection con) {
        super(con);
    }

    public DemoEntity getOrThrow(int id) throws SQLException, NotFoundException {
        String query = "SELECT * FROM  demo_entity  WHERE id=?";
        try (PreparedStatement ps = this.con.prepareStatement(query);){
            ps.setInt(1, id);
            ResultSet rs = ps.executeQuery();
            if (rs.next()) {
                DemoEntity demoEntity = this.getFromRs(rs);
                return demoEntity;
            }
            throw new NotFoundException("Not found entity with ID: " + id);
        }
    }

    public void update(DemoEntity entity) throws SQLException {
        int id = this.updateOrInsert("UPDATE  demo_entity  SET title=?, config=? WHERE id=?", "INSERT INTO  demo_entity (title, config, id) VALUES (?, ?, ?)", entity.getTitle(), entity.getConfig(), entity.getId());
        if (id > 0) {
            entity.setId(id);
        }
    }

    public void delete(int id) throws SQLException {
        this.deleteById(" demo_entity ", id);
    }

    public void search(Pageable<DemoEntity> result, String filter) throws SQLException {
        Page page = result.getPage();
        try (PreparedQuery pq = new PreparedQuery(this.con);){
            pq.addQuery("SELECT SQL_CALC_FOUND_ROWS * FROM  demo_entity  WHERE 1>0");
            if (Utils.notBlankString(filter)) {
                pq.addQuery(" AND (title LIKE ? OR config LIKE ?)");
                String pattern = LikePattern.SUB.get(filter);
                pq.addString(pattern).addString(pattern);
            }
            pq.addQuery(" ORDER BY title");
            pq.addQuery(page.getLimitSql());
            ResultSet rs = pq.executeQuery();
            while (rs.next()) {
                result.add(this.getFromRs(rs));
            }
            page.setRecordCount(pq.getPrepared());
        }
    }

    private DemoEntity getFromRs(ResultSet rs) throws SQLException {
        DemoEntity entity = new DemoEntity();
        entity.setId(rs.getInt("id"));
        entity.setTitle(rs.getString("title"));
        entity.setConfig(rs.getString("config"));
        return entity;
    }
}

