/*
 * Decompiled with CFR 0.152.
 */
package org.bgerp.app.l10n;

import com.google.common.annotations.VisibleForTesting;
import java.io.File;
import java.io.FileInputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.apache.commons.lang3.StringUtils;
import org.bgerp.app.cfg.Setup;
import org.bgerp.app.l10n.Lang;
import org.bgerp.app.l10n.Localizer;
import org.bgerp.app.servlet.filter.AuthFilter;
import org.bgerp.app.servlet.util.ServletUtils;
import org.bgerp.util.Dynamic;
import org.bgerp.util.Log;
import org.bgerp.util.xml.XMLUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import ru.bgcrm.plugin.Plugin;
import ru.bgcrm.plugin.PluginManager;
import ru.bgcrm.util.Utils;

public class Localization {
    private static final Log log = Log.getLog();
    public static final String FILE_NAME = "l10n.xml";
    public static final String LANG_SYS = "sys";
    public static final String LANG_RU = Lang.RU.getId();
    public static final String LANG_EN = Lang.EN.getId();
    public static final String LANG_DE = Lang.DE.getId();
    private static final String PLUGIN_CUSTOM = "custom";
    private static volatile Map<String, Localization> localizations;
    private final String pluginId;
    private final Map<String, Map<String, String>> translations;

    private Localization(String pluginId, Document doc) {
        this.pluginId = pluginId;
        this.translations = new HashMap<String, Map<String, String>>(300);
        this.parseFile(doc);
    }

    public static Localization getLocalization(Plugin p) {
        Document doc = p.getXml(FILE_NAME, null);
        if (doc == null) {
            return null;
        }
        return new Localization(p.getId(), doc);
    }

    private void parseFile(Document doc) {
        for (Element phrase : XMLUtils.elements(doc.getDocumentElement().getChildNodes())) {
            HashMap<String, String> phraseMap = null;
            for (Element lang : XMLUtils.elements(phrase.getChildNodes())) {
                String value = XMLUtils.getElementText(lang);
                if (phraseMap == null) {
                    phraseMap = new HashMap<String, String>(4);
                    if (this.translations.containsKey(value)) {
                        log.warn("Duplicated key: '{}' in '{}' l10n.xml", value, this);
                    }
                    this.translations.put(value, phraseMap);
                }
                phraseMap.put(lang.getNodeName(), value);
            }
        }
    }

    public String toString() {
        return this.pluginId;
    }

    String getTranslation(String toLang, String value) {
        return this.translations.containsKey(value) ? this.translations.get(value).get(toLang) : null;
    }

    public static Localizer getLocalizer(HttpServletRequest request) {
        return Localization.getLocalizer(Localization.getLang(request), Localization.getPluginIdsFromURI(ServletUtils.getRequestURI(request)));
    }

    @VisibleForTesting
    static String[] getPluginIdsFromURI(String uri) {
        String pluginUriPrefix = "/plugin/";
        int pluginUriPrefixLength = "/plugin/".length();
        ArrayList<String> pluginIds = new ArrayList<String>();
        int pos = 0;
        while ((pos = uri.indexOf("/plugin/", pos + 1)) > 0) {
            pluginIds.add(StringUtils.substringBefore((String)uri.substring(pos + pluginUriPrefixLength), (String)"/"));
        }
        return pluginIds == null ? null : pluginIds.toArray(new String[0]);
    }

    @Dynamic
    public static String getLang(HttpServletRequest request) {
        String langKeyName = "lang";
        String result = null;
        if (request != null && AuthFilter.getUser(request) == null) {
            result = request.getParameter("lang");
            HttpSession session = request.getSession(false);
            if (Utils.isBlankString(result) && session != null) {
                result = (String)session.getAttribute("lang");
            }
            request.getSession().setAttribute("lang", (Object)result);
        }
        if (Utils.isBlankString(result)) {
            result = Setup.getSetup().get("lang", LANG_EN);
        }
        return result;
    }

    public static final String getLang() {
        return Localization.getLang(null);
    }

    @Deprecated
    public static final String getSysLang() {
        log.warndMethod("getSysLang", "getLang");
        return Localization.getLang();
    }

    public static Localizer getLocalizer(String toLang, String ... pluginIds) {
        Localization.loadLocalizations();
        ArrayList<Localization> localizations = new ArrayList<Localization>(3);
        Localization custom = Localization.localizations.get(PLUGIN_CUSTOM);
        if (custom != null) {
            localizations.add(custom);
        }
        if (pluginIds != null) {
            for (String pluginId : pluginIds) {
                Localization pluginL10n;
                if (pluginId == null || "kernel".equals(pluginId) || (pluginL10n = Localization.localizations.get(pluginId)) == null) continue;
                localizations.add(pluginL10n);
            }
        }
        localizations.add(Localization.localizations.get("kernel"));
        return new Localizer(toLang, localizations.toArray(new Localization[0]));
    }

    @Dynamic
    public static Localizer getLocalizer(String pluginId, HttpServletRequest request) {
        return Localization.getLocalizer(Localization.getLang(request), pluginId);
    }

    public static Localizer getLocalizer() {
        return Localization.getLocalizer(Localization.getLang(), new String[]{null});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void loadLocalizations() {
        Class<Localization> clazz = Localization.class;
        synchronized (Localization.class) {
            if (localizations == null) {
                try {
                    log.info("Loading localizations..", new Object[0]);
                    localizations = new HashMap<String, Localization>();
                    File customL10n = new File(PLUGIN_CUSTOM, FILE_NAME);
                    if (customL10n.exists()) {
                        Localization.loadL10n(new Localization(PLUGIN_CUSTOM, XMLUtils.parseDocument(new FileInputStream(customL10n))));
                    }
                    for (Plugin p : PluginManager.getInstance().getFullSortedPluginList()) {
                        Localization.loadL10n(p.getLocalization());
                    }
                    localizations = Collections.unmodifiableMap(localizations);
                }
                catch (Exception e) {
                    log.error(e);
                }
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return;
        }
    }

    private static void loadL10n(Localization localization) throws Exception {
        if (localization == null) {
            return;
        }
        localizations.put(localization.pluginId, localization);
        log.debug("Loaded localization for: {}", localization.pluginId);
    }
}

