/*
 * Decompiled with CFR 0.152.
 */
package ru.bgcrm.plugin.bgbilling.proto.model.entity;

import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import ru.bgcrm.plugin.bgbilling.proto.model.entity.EntityAttr;
import ru.bgcrm.plugin.bgbilling.proto.model.entity.EntitySpecAttrType;
import ru.bgcrm.util.Utils;

public class EntityAttrEmail
extends EntityAttr {
    private String data;
    private List<EmailContact> contactList;
    private static final Pattern FORMAT_PATTERN = Pattern.compile("^(.*)\\s*+\\<(.*)\\>$");

    protected EntityAttrEmail() {
        super(EntitySpecAttrType.EMAIL);
    }

    public EntityAttrEmail(int entityId, int entitySpecAttrId) {
        super(EntitySpecAttrType.EMAIL, entityId, entitySpecAttrId);
    }

    public EntityAttrEmail addContact(String name, String address) {
        this.getContactList().add(new EmailContact(name, address));
        return this;
    }

    private static List<EmailContact> read(String value) {
        ArrayList<EmailContact> result = new ArrayList<EmailContact>(4);
        if (Utils.isBlankString(value)) {
            return result;
        }
        for (String email : value.split("\n")) {
            if (email.trim().isEmpty()) continue;
            EmailContact emailData = new EmailContact();
            Matcher matcher = FORMAT_PATTERN.matcher(email);
            if (matcher.matches()) {
                emailData.setAddress(matcher.group(2).trim());
                emailData.setName(matcher.group(1).trim());
            } else {
                emailData.setAddress(email.trim());
                emailData.setName("");
            }
            result.add(emailData);
        }
        return result;
    }

    public List<EmailContact> getContactList() {
        if (this.contactList == null) {
            this.contactList = EntityAttrEmail.read(this.data);
            this.data = null;
        }
        return this.contactList;
    }

    public static class EmailContact {
        private String name;
        private String address;

        public EmailContact() {
        }

        public EmailContact(String name, String address) {
            this.name = name;
            this.address = address;
        }

        public String getName() {
            return Utils.maskNull(this.name).replace("\"", "");
        }

        public void setName(String name) {
            this.name = name;
        }

        public String getAddress() {
            return this.address;
        }

        public void setAddress(String address) {
            this.address = address;
        }

        public String toString() {
            return (String)(this.name != null ? this.name + " " : "") + "<" + this.address + ">";
        }
    }
}

