/*
 * Decompiled with CFR 0.152.
 */
package ru.bgcrm.plugin.bgbilling.event.listener;

import org.bgerp.app.event.EventProcessor;
import org.bgerp.app.event.iface.EventListener;
import org.bgerp.app.exception.BGException;
import org.bgerp.app.exception.BGMessageException;
import org.bgerp.app.exception.BGMessageExceptionWithoutL10n;
import ru.bgcrm.event.link.LinkAddingEvent;
import ru.bgcrm.event.link.LinksToRemovingEvent;
import ru.bgcrm.model.CommonObjectLink;
import ru.bgcrm.plugin.bgbilling.DBInfo;
import ru.bgcrm.plugin.bgbilling.DBInfoManager;
import ru.bgcrm.plugin.bgbilling.proto.dao.ContractParamDAO;
import ru.bgcrm.plugin.bgbilling.proto.model.Contract;
import ru.bgcrm.util.sql.ConnectionSet;

public class LinkChangingListener {
    public LinkChangingListener() {
        EventProcessor.subscribe(new EventListener<LinkAddingEvent>(){

            @Override
            public void notify(LinkAddingEvent e, ConnectionSet connectionSet) throws BGMessageException {
                LinkChangingListener.this.customerChanging(e, e.getLink().getObjectId());
            }
        }, LinkAddingEvent.class);
        EventProcessor.subscribe(new EventListener<LinksToRemovingEvent>(){

            @Override
            public void notify(LinksToRemovingEvent e, ConnectionSet connectionSet) throws BGMessageException {
                LinkChangingListener.this.customerChanging(e, 0);
            }
        }, LinksToRemovingEvent.class);
    }

    private void customerChanging(LinkAddingEvent event, int customerId) throws BGMessageException {
        block5: {
            CommonObjectLink link = event.getLink();
            if (!"customer".equals(link.getObjectType()) || !link.getLinkObjectType().startsWith("contract:")) {
                return;
            }
            String billingId = new Contract(link).getBillingId();
            DBInfo dbInfo = DBInfoManager.getInstance().getDbInfoMap().get(billingId);
            if (dbInfo == null) {
                throw new BGMessageExceptionWithoutL10n("\u041d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d \u0431\u0438\u043b\u043b\u0438\u043d\u0433 \u0441 \u0438\u0434\u0435\u043d\u0442\u0438\u0444\u0438\u043a\u0430\u0442\u043e\u0440\u043e\u043c: " + billingId, new Object[0]);
            }
            int customerIdParam = dbInfo.getCustomerIdParam();
            if (customerIdParam <= 0) {
                throw new BGMessageExceptionWithoutL10n("\u041d\u0435 \u043e\u043f\u0440\u0435\u0434\u0435\u043b\u0451\u043d \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440 'customerIdParam' \u0434\u043b\u044f \u0441\u0435\u0440\u0432\u0435\u0440\u0430.", new Object[0]);
            }
            int contractId = link.getLinkObjectId();
            try {
                ContractParamDAO contractParamDAO = new ContractParamDAO(event.getUser(), dbInfo);
                contractParamDAO.updateTextParameter(contractId, customerIdParam, customerId > 0 ? String.valueOf(customerId) : "");
            }
            catch (Exception e) {
                if (customerId <= 0) break block5;
                throw new BGException("\u041e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u0438\u0432\u044f\u0437\u043a\u0438 \u0434\u043e\u0433\u043e\u0432\u043e\u0440\u0430 \u043a \u043a\u043e\u043d\u0442\u0440\u0430\u0433\u0435\u043d\u0442\u0443: " + e.getMessage(), e);
            }
        }
    }
}

