/*
 * Decompiled with CFR 0.152.
 */
package org.bgerp.plugin.bil.subscription;

import java.io.FileOutputStream;
import java.io.OutputStream;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.Period;
import java.time.ZoneId;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import javassist.NotFoundException;
import org.bgerp.app.cfg.ConfigMap;
import org.bgerp.app.dist.lic.License;
import org.bgerp.app.exception.BGException;
import org.bgerp.app.exception.BGMessageException;
import org.bgerp.app.l10n.Localization;
import org.bgerp.cache.ParameterCache;
import org.bgerp.dao.FileDataDAO;
import org.bgerp.dao.param.ParamValueDAO;
import org.bgerp.model.file.FileData;
import org.bgerp.plugin.bil.subscription.dao.SubscriptionDAO;
import org.bgerp.plugin.bil.subscription.model.Subscription;
import org.bgerp.plugin.bil.subscription.model.SubscriptionLicense;
import org.bgerp.util.Log;
import ru.bgcrm.event.ParamChangedEvent;
import ru.bgcrm.util.TimeUtils;
import ru.bgcrm.util.Utils;
import ru.bgcrm.util.sql.ConnectionSet;

public class Config
extends org.bgerp.app.cfg.Config {
    private final SortedMap<Integer, Subscription> subscriptions;
    private final String signKeyFile;
    private final String signKeyPswd;
    private final int paramUserIncomingTaxPercentId;
    private final int paramSubscriptionId;
    private final int paramEmailId;
    private final int paramLimitId;
    private final int paramDateToId;
    private final int paramLicFileId;
    private final int paramServiceCostId;
    private final int paramDiscountId;
    private final int paramCostId;
    private final Set<Integer> costUpdateParams;
    private final Set<Integer> licFileUpdateParams;
    private final int paramProductId;
    private final long maxDateToMonths;

    protected Config(ConfigMap config) {
        super(null);
        config = config.sub("subscription:");
        this.subscriptions = this.loadSubscriptions(config);
        this.signKeyFile = config.get("sign.key.file", System.getProperty("user.home") + "/.ssh/id_rsa");
        this.signKeyPswd = config.get("sign.key.pswd");
        this.paramUserIncomingTaxPercentId = config.getInt("param.user.incoming.tax.percent");
        this.paramSubscriptionId = config.getInt("param.subscription");
        this.paramLicFileId = config.getInt("param.lic");
        this.paramEmailId = config.getInt("param.email");
        this.paramLimitId = config.getInt("param.limit");
        this.paramDateToId = (int)config.getSokLong(0L, "param.dateTo", "param.date.to");
        this.paramServiceCostId = config.getInt("param.cost.service");
        this.paramDiscountId = config.getInt("param.cost.discount");
        this.paramCostId = config.getInt("param.cost");
        this.paramProductId = (int)config.getSokLong(0L, "param.productId", "param.product.id");
        this.maxDateToMonths = config.getSokLong(3L, "max.dateTo.months", "max.date.to.months");
        this.costUpdateParams = Set.of(Integer.valueOf(this.paramLimitId), Integer.valueOf(this.paramDateToId), Integer.valueOf(this.paramServiceCostId), Integer.valueOf(this.paramDiscountId));
        this.licFileUpdateParams = Set.of(Integer.valueOf(this.paramEmailId), Integer.valueOf(this.paramLimitId), Integer.valueOf(this.paramDateToId));
    }

    private SortedMap<Integer, Subscription> loadSubscriptions(ConfigMap config) {
        TreeMap<Integer, Subscription> result = new TreeMap<Integer, Subscription>();
        for (Map.Entry<Integer, ConfigMap> me : config.subIndexed("subscription.").entrySet()) {
            result.put(me.getKey(), new Subscription((int)me.getKey(), me.getValue()));
        }
        return Collections.unmodifiableSortedMap(result);
    }

    public Subscription getSubscriptionOrThrow(int id) throws NotFoundException {
        Subscription result = (Subscription)this.subscriptions.get(id);
        if (result == null) {
            throw new NotFoundException(Log.format("Not found subscription ID: {}", id));
        }
        return result;
    }

    public Collection<Subscription> getSubscriptions() {
        return this.subscriptions.values();
    }

    public int getParamUserIncomingTaxPercentId() {
        return this.paramUserIncomingTaxPercentId;
    }

    public int getParamEmailId() {
        return this.paramEmailId;
    }

    public int getParamSubscriptionId() {
        return this.paramSubscriptionId;
    }

    public int getParamLimitId() {
        return this.paramLimitId;
    }

    public int getParamDateToId() {
        return this.paramDateToId;
    }

    public int getParamProductId() {
        return this.paramProductId;
    }

    public int getParamServiceCostId() {
        return this.paramServiceCostId;
    }

    public int getParamDiscountId() {
        return this.paramDiscountId;
    }

    void paramChanged(ParamChangedEvent e, ConnectionSet conSet) throws Exception {
        int paramId = e.getParameter().getId();
        boolean licUpdate = true;
        if (paramId == this.paramDateToId) {
            licUpdate = this.dateToChanged(e, conSet);
        }
        if (licUpdate && this.licFileUpdateParams.contains(paramId)) {
            this.updateLic(e.getObjectId(), conSet);
        }
        if (this.costUpdateParams.contains(paramId)) {
            this.updateCost(e.getObjectId(), conSet);
        }
    }

    private boolean dateToChanged(ParamChangedEvent e, ConnectionSet conSet) throws Exception {
        Date value = (Date)e.getValue();
        if (value == null) {
            new ParamValueDAO(conSet.getConnection()).updateParamFile(e.getObjectId(), this.paramLicFileId, -1, null);
            return false;
        }
        if (this.maxDateToMonths > 0L && this.maxDateToMonths < (long)Period.between(LocalDate.now(), value.toInstant().atZone(ZoneId.systemDefault()).toLocalDate()).getMonths()) {
            throw new BGMessageException(Localization.getLocalizer("subscription", e.getForm().getHttpRequest()), "Date To is too far in the future.", new Object[0]);
        }
        return true;
    }

    private void updateCost(int processId, ConnectionSet conSet) throws Exception {
        Subscription subscription = this.getSubscription(conSet, processId);
        SubscriptionDAO dao = new SubscriptionDAO(conSet.getSlaveConnection());
        BigDecimal cost = dao.getCost(this, subscription, processId);
        new ParamValueDAO(conSet.getConnection()).updateParamMoney(processId, this.paramCostId, cost);
    }

    public FileData updateLic(int processId, ConnectionSet conSet) throws Exception {
        ParamValueDAO paramDao = new ParamValueDAO(conSet.getConnection());
        Integer limitId = Utils.getFirst(paramDao.getParamList(processId, this.paramLimitId));
        String limit = limitId != null ? ParameterCache.getListParamValuesMap(this.paramLimitId).get(limitId).getTitle() : "";
        SubscriptionLicense license = new SubscriptionLicense().withId(String.valueOf(processId)).withEmail(Utils.getFirst(paramDao.getParamEmail(processId, this.paramEmailId).values())).withDateTo(TimeUtils.format(paramDao.getParamDate(processId, this.paramDateToId), "dd.MM.yyyy")).withLimit(limit);
        SubscriptionDAO dao = new SubscriptionDAO(conSet.getSlaveConnection());
        for (String productId : dao.getProducts(this, processId)) {
            license.withPlugin(productId);
        }
        License lic = new License(license.build());
        byte[] signed = lic.sign(this.signKeyFile, this.signKeyPswd);
        FileData fd = Utils.getFirst(paramDao.getParamFile(processId, this.paramLicFileId).values());
        paramDao = new ParamValueDAO(conSet.getConnection());
        if (fd == null) {
            fd = new FileData();
            fd.setTitle("lic.data");
            new FileDataDAO(conSet.getConnection()).add(fd);
            paramDao.updateParamFile(processId, this.paramLicFileId, 0, fd);
        } else {
            fd.setOutputStream(new FileOutputStream(new FileDataDAO(null).getFile(fd)));
        }
        try (OutputStream out = fd.getOutputStream();){
            out.write(signed);
        }
        return fd;
    }

    private Subscription getSubscription(ConnectionSet conSet, int processId) throws Exception {
        ParamValueDAO paramValueDao = new ParamValueDAO(conSet.getSlaveConnection());
        Integer subscriptionId = Utils.getFirst(paramValueDao.getParamList(processId, this.paramSubscriptionId));
        if (subscriptionId == null) {
            throw new BGException("Undefined subscription", new Object[0]);
        }
        return this.getSubscriptionOrThrow(subscriptionId);
    }
}

