/*
 * Decompiled with CFR 0.152.
 */
package org.bgerp.app.dist.lic;

import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.time.LocalDate;
import java.time.temporal.ChronoUnit;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.Map;
import java.util.Random;
import java.util.Scanner;
import java.util.Set;
import java.util.stream.Collectors;
import org.bgerp.action.admin.LicenseAction;
import org.bgerp.app.cfg.ConfigMap;
import org.bgerp.app.cfg.Preferences;
import org.bgerp.app.cfg.Setup;
import org.bgerp.app.dist.lic.Sign;
import org.bgerp.app.servlet.user.LoginStat;
import org.bgerp.event.client.LicenseEvent;
import org.bgerp.model.base.Message;
import org.bgerp.util.IOUtils;
import org.bgerp.util.TimeConvert;
import ru.bgcrm.model.user.User;
import ru.bgcrm.plugin.Plugin;
import ru.bgcrm.plugin.PluginManager;
import ru.bgcrm.servlet.ActionServlet;
import ru.bgcrm.struts.form.DynActionForm;
import ru.bgcrm.util.TimeUtils;
import ru.bgcrm.util.Utils;

public class License {
    private static final Sign SIGN = new Sign("Team <team@bgerp.org>", "AAAAB3NzaC1yc2EAAAADAQABAAABAQDE4LeZHn/rW/J5fX52ozR2B+wwxEqfE9lhkZDmG3wCCtGNXzxFpQXVRROHi0FwSZAnQXLvTwMH1Lw54SBxPbEk3f35B3ULorIzibMwokzdD6daJdmI9nq4fm7FcpnM8Wv81RvRbKjBFQz1waJLiALpTxBSOrgbFFM6jilgv9fSEJNsz2c/sh/TlMxa5XlHhwutdp6qip2QyTngD8oq1ZNtHqzx3kI/tj2L+fRZEhWZD2Fj9oWKs9uiS+G4Gzsty2bA6hHYMyDdzFKUvN3I9Lj9NF2ZeLalsen5zaoHh5kzPyzCymZfVupu6M1DQqBtE5rQgY+JWXDegBYzRawiwzpx");
    public static final String FILE_NAME = "lic.data";
    private static final String KEY_LIC = "lic.";
    public static final String KEY_LIC_ID = "lic.id";
    public static final String KEY_LIC_EMAIL = "lic.email";
    public static final String KEY_LIC_LIMIT = "lic.limit";
    public static final String KEY_LIC_DATE_TO = "lic.date.to";
    public static final String KEY_LIC_PLUGIN = "lic.plugin.";
    private static final int KEY_LIC_PLUGIN_LENGTH = "lic.plugin.".length();
    public static final String KEY_LIC_SIGN = "lic.sign";
    private static final int CHECK_EXPIRATION_DAYS_BEFORE = 3;
    private static final int CHECK_EXPIRATION_NOTIFICATION_RANDOM_BOUND = 200;
    private static final int CHECK_ERROR_NOTIFICATION_RANDOM_BOUND = 100;
    private final LocalDate created = LocalDate.now();
    private final String data;
    private final ConfigMap config;
    private final int limit;
    private final Date dateTo;
    private final byte[] digest;
    private final String error;
    private final Set<String> plugins;

    public License(String data) {
        this.data = data;
        this.config = new Preferences(data);
        this.limit = this.config.getInt(KEY_LIC_LIMIT);
        this.dateTo = TimeUtils.parse(this.config.get(KEY_LIC_DATE_TO), "dd.MM.yyyy");
        this.digest = this.digest();
        this.error = this.error();
        this.plugins = this.plugins();
    }

    public String getData() {
        return this.data;
    }

    public byte[] getDigest() {
        return this.digest;
    }

    public String getError() {
        return this.error;
    }

    public Set<String> getPlugins() {
        return this.plugins;
    }

    public byte[] sign(String keyFilePath, String keyFilePswd) throws Exception {
        Sign sign = new Sign("key.id", new String(IOUtils.read(keyFilePath), StandardCharsets.UTF_8), keyFilePswd);
        StringBuilder data = new StringBuilder(this.data);
        data.append("lic.sign=").append(sign.signatureGenerate(this.getDigest())).append("\n");
        return data.toString().getBytes(StandardCharsets.UTF_8);
    }

    public void check(DynActionForm form) {
        if (form.l == null || !this.isCheckEnabled()) {
            return;
        }
        User user = form.getUser();
        if (user == null) {
            return;
        }
        boolean actionAllowed = user.checkPerm(ActionServlet.pathId(LicenseAction.class, "null"));
        if (Utils.isBlankString(this.error)) {
            if (!actionAllowed || 3L < ChronoUnit.DAYS.between(LocalDate.now(), TimeConvert.toLocalDate(this.dateTo))) {
                return;
            }
            if (Setup.getSetup().getBoolean("test.license.check.notification") || new Random().nextInt(200) == 0) {
                form.getResponse().addEvent(new LicenseEvent(new Message(form.l.l("License Will Expire Soon", new Object[0]), form.l.l("Your license will expire at {}", TimeUtils.format(this.dateTo, "ymd"))), true));
            }
        } else if (Setup.getSetup().getBoolean("test.license.check.error") || new Random().nextInt(100) == 0) {
            form.getResponse().addEvent(new LicenseEvent(new Message(form.l.l("License Check Error", new Object[0]), this.error), actionAllowed));
        }
    }

    public boolean checkSessionLimit() {
        if (!this.isCheckEnabled() || Utils.notBlankString(this.error) || this.limit == 0) {
            return true;
        }
        return LoginStat.instance().loggedUsers().size() < this.limit;
    }

    public boolean isCreatedToday() {
        return ChronoUnit.DAYS.between(this.created, LocalDate.now()) == 0L;
    }

    private boolean isCheckEnabled() {
        return true;
    }

    private byte[] digest() {
        StringBuilder buffer = new StringBuilder(1000);
        try (Scanner scanner = new Scanner(this.data);){
            while (scanner.hasNextLine()) {
                String line = scanner.nextLine();
                if (line.startsWith(KEY_LIC_SIGN)) {
                    break;
                }
                buffer.append(line);
            }
        }
        try {
            MessageDigest digest = MessageDigest.getInstance("SHA-512");
            return digest.digest(buffer.toString().getBytes(StandardCharsets.UTF_8));
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException("Digest exception", e);
        }
    }

    private String error() {
        if (Utils.isBlankString(this.data)) {
            return "License is missing";
        }
        String signature = this.config.get(KEY_LIC_SIGN);
        if (Utils.isEmptyString(signature)) {
            return "Signature is undefined";
        }
        if (!SIGN.signatureVerify(this.digest, signature)) {
            return "Signature is not correct";
        }
        if (this.dateTo == null || TimeUtils.dateBefore(this.dateTo, new Date())) {
            return "Date To is not defined or expired";
        }
        Set<String> plugins = this.plugins();
        Set missing = PluginManager.getInstance().getPluginList().stream().filter(p -> !p.isSystem() && !p.getId().startsWith("custom.")).map(Plugin::getId).filter(id -> !plugins.contains(id)).collect(Collectors.toSet());
        if (!missing.isEmpty()) {
            return "Missing plugins: " + Utils.toString(missing);
        }
        return null;
    }

    private Set<String> plugins() {
        HashSet<String> result = new HashSet<String>();
        for (Map.Entry<String, String> me : this.config.entrySet()) {
            String key = me.getKey();
            if (!key.startsWith(KEY_LIC_PLUGIN) || !Utils.parseBoolean(me.getValue(), false).booleanValue()) continue;
            result.add(key.substring(KEY_LIC_PLUGIN_LENGTH));
        }
        return Collections.unmodifiableSet(result);
    }

    public String toString() {
        return "License [created=" + String.valueOf(this.created) + "]";
    }
}

