/*
 * Decompiled with CFR 0.152.
 */
package ru.bgcrm.plugin.bgbilling.model.process.wizard;

import java.sql.Connection;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.bgerp.app.cfg.ConfigMap;
import org.bgerp.app.cfg.bean.annotation.Bean;
import ru.bgcrm.dao.process.ProcessLinkDAO;
import ru.bgcrm.model.CommonObjectLink;
import ru.bgcrm.model.customer.Customer;
import ru.bgcrm.model.process.wizard.LinkCustomerStep;
import ru.bgcrm.model.process.wizard.base.StepData;
import ru.bgcrm.model.process.wizard.base.WizardData;
import ru.bgcrm.plugin.bgbilling.ContractTypesConfig;
import ru.bgcrm.plugin.bgbilling.model.ContractType;
import ru.bgcrm.plugin.bgbilling.model.process.wizard.BaseStep;
import ru.bgcrm.struts.form.DynActionForm;

@Bean
public class CreateContractsStep
extends BaseStep {
    private final ContractTypesConfig typesConfig;
    private final boolean showContractTitle;

    public CreateContractsStep(ConfigMap config) {
        super(config);
        this.typesConfig = new ContractTypesConfig(config, "contractType.");
        this.showContractTitle = config.getBoolean("showContractTitle", false);
    }

    public Map<Integer, ContractType> getTypeMap() {
        return this.typesConfig.getTypeMap();
    }

    public boolean getShowContractTitle() {
        return this.showContractTitle;
    }

    @Override
    public String getJsp() {
        return "/WEB-INF/jspf/user/plugin/bgbilling/process/wizard/step_create_contracts.jsp";
    }

    @Override
    public StepData<?> data(WizardData data) {
        return new Data(this, data);
    }

    public static class Data
    extends StepData<CreateContractsStep> {
        private Customer customer;
        private List<CommonObjectLink> contractLinkList;

        private Data(CreateContractsStep step, WizardData data) {
            super(step, data);
        }

        public List<CommonObjectLink> getContractLinkList() {
            return this.contractLinkList;
        }

        public Customer getCustomer() {
            return this.customer;
        }

        public List<ContractType> getAllowedTypeList() {
            ArrayList<ContractType> result = new ArrayList<ContractType>();
            HashSet<Integer> existsTypes = new HashSet<Integer>();
            for (CommonObjectLink link : this.contractLinkList) {
                existsTypes.add(link.getConfigMap().getInt("type", 0));
            }
            for (ContractType type : ((CreateContractsStep)this.step).getTypeMap().values()) {
                if (existsTypes.contains(type.getId())) continue;
                result.add(type);
            }
            return result;
        }

        @Override
        public boolean isFilled(DynActionForm form, Connection con) {
            List<StepData<?>> stepDataList = this.data.getStepDataList();
            for (int i = stepDataList.indexOf(this); i >= 0; --i) {
                StepData<?> stepData = stepDataList.get(i);
                if (this.customer == null && stepData instanceof LinkCustomerStep.Data) {
                    LinkCustomerStep.Data scStepData = (LinkCustomerStep.Data)stepData;
                    this.customer = scStepData.getCustomer();
                }
                if (this.customer != null) break;
            }
            this.contractLinkList = new ProcessLinkDAO(con).getObjectLinksWithType(this.data.getProcess().getId(), "contract%");
            return this.contractLinkList.size() > 0;
        }
    }
}

