/*
 * Decompiled with CFR 0.152.
 */
package ru.bgcrm.model.user;

import com.google.common.annotations.VisibleForTesting;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javassist.NotFoundException;
import org.apache.commons.lang3.StringUtils;
import org.bgerp.action.base.Actions;
import org.bgerp.action.base.TitledAction;
import org.bgerp.action.base.TitledActionFactory;
import org.bgerp.action.util.Invoker;
import org.bgerp.app.cfg.ConfigMap;
import org.bgerp.app.l10n.Localization;
import org.bgerp.app.l10n.Localizer;
import org.bgerp.exec.CorrectPermissions;
import org.bgerp.util.Log;
import org.bgerp.util.xml.XMLUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import ru.bgcrm.plugin.Plugin;
import ru.bgcrm.plugin.PluginManager;
import ru.bgcrm.util.Utils;

public class PermissionNode {
    private static final Log log = Log.getLog();
    @VisibleForTesting
    static final String FILE_NAME = "action.xml";
    private static final String DELIMITER = " / ";
    public static final String ACTION_METHOD_UNSPECIFIED = "unspecified";
    private static volatile List<PermissionNode> permissionTrees;
    private String action;
    private List<String> actions = new ArrayList<String>();
    private String title;
    private String titlePath;
    private String description = "";
    private boolean allowAll;
    private boolean notLogging;
    private PermissionNode parent;
    private List<PermissionNode> children = new ArrayList<PermissionNode>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<PermissionNode> getPermissionTrees() {
        if (permissionTrees != null) {
            return permissionTrees;
        }
        Log log = PermissionNode.log;
        synchronized (log) {
            if (permissionTrees != null) {
                return permissionTrees;
            }
            ArrayList<PermissionNode> newPermissionTrees = new ArrayList<PermissionNode>(20);
            for (Plugin p : PluginManager.getInstance().getPluginList()) {
                Document doc = p.getXml(FILE_NAME, null);
                if (doc == null) continue;
                newPermissionTrees.add(new PermissionNode(null, Localization.getLocalizer(Localization.getLang(), p.getId()), doc.getDocumentElement()));
            }
            permissionTrees = Collections.unmodifiableList(newPermissionTrees);
            return permissionTrees;
        }
    }

    public static Map<String, ConfigMap> primaryActions(Map<String, ConfigMap> permMap) {
        HashMap<String, ConfigMap> result = new HashMap<String, ConfigMap>(permMap.size());
        for (Map.Entry<String, ConfigMap> perm : permMap.entrySet()) {
            String action = perm.getKey();
            PermissionNode node = PermissionNode.getPermissionNode(action);
            if (node == null) {
                log.warn("Not found action node '{}', run '{}' class to fix", action, CorrectPermissions.class.getName());
                continue;
            }
            result.put(node.getAction(), perm.getValue());
        }
        return result;
    }

    public static PermissionNode getPermissionNode(String action) {
        PermissionNode node = null;
        for (PermissionNode treeNode : PermissionNode.getPermissionTrees()) {
            node = treeNode.findPermissionNode(action);
            if (node == null) continue;
            return node;
        }
        return null;
    }

    public static PermissionNode getPermissionNodeOrThrow(String action) throws NotFoundException {
        PermissionNode result = PermissionNode.getPermissionNode(action);
        if (result == null) {
            throw new NotFoundException(Log.format("Permission node not found for action '{}'", action));
        }
        return result;
    }

    private PermissionNode(String action, String title) {
        this.setAction(action);
        this.title = title;
    }

    PermissionNode(PermissionNode parent, Localizer l, Element node) {
        this(node.getAttribute("action"), node.getAttribute("title"));
        this.parent = parent;
        this.allowAll = Utils.parseBoolean(node.getAttribute("allowAll"));
        this.notLogging = Utils.parseBoolean(node.getAttribute("notLogging"));
        this.titlePath = parent != null && Utils.notBlankString(parent.getTitle()) ? parent.getTitlePath() + DELIMITER + this.title : this.title;
        this.loadChildren(l, node);
        if (Utils.notEmptyString(this.action) && this.children.isEmpty()) {
            this.description = XMLUtils.getElementText(node);
        }
        this.validateAction();
    }

    private void validateAction() {
        if (Utils.isBlankString(this.action)) {
            return;
        }
        Actions.Action a = Actions.getById(PermissionNode.actionId(this.action));
        if (a != null) {
            this.validateActionMethod(a.getTypeClass());
        }
    }

    public static String actionId(String action) {
        int pos = action.indexOf(58);
        if (pos > 0) {
            return action.substring(0, pos);
        }
        return action;
    }

    private void validateActionMethod(Class<?> actionClass) {
        String actionMethod = PermissionNode.actionMethod(this.action);
        try {
            Invoker.find(actionClass, actionMethod);
        }
        catch (NoSuchMethodException e) {
            log.warnd("Missing correct action method '{}' in class '{}'", actionMethod, actionClass.getName());
        }
    }

    public static String actionMethod(String action) {
        String result = StringUtils.substringAfter((String)action, (String)":");
        if ("null".equals(result) || Utils.isBlankString(result)) {
            result = ACTION_METHOD_UNSPECIFIED;
        }
        return result;
    }

    private void loadChildren(Localizer l, Element node) {
        String actionFactory = node.getAttribute("actionFactory");
        if (Utils.notBlankString(actionFactory)) {
            for (TitledAction action : TitledActionFactory.create(actionFactory)) {
                this.children.add(new PermissionNode(action.getAction(), action.getTitle()));
            }
        } else {
            for (Element child : XMLUtils.selectElements(node, "item")) {
                this.children.add(new PermissionNode(this, l, child));
            }
        }
    }

    public String getAction() {
        return this.action;
    }

    public List<String> getActions() {
        return this.actions;
    }

    private void setAction(String action) {
        List<String> actionList = Utils.toList(action, ";,");
        if (actionList.size() > 1) {
            this.action = actionList.get(0);
            this.actions = actionList;
        } else {
            this.action = action;
        }
    }

    public String getTitle() {
        return this.title;
    }

    public String getTitlePath() {
        return this.titlePath;
    }

    public String getDescription() {
        return this.description;
    }

    public boolean isAllowAll() {
        return this.allowAll;
    }

    public boolean isNotLogging() {
        return this.notLogging;
    }

    public PermissionNode getParent() {
        return this.parent;
    }

    public List<PermissionNode> getChildren() {
        return this.children;
    }

    @VisibleForTesting
    PermissionNode findPermissionNode(String action) {
        PermissionNode node = this;
        if (action.equals(node.getAction()) || node.getActions().contains(action)) {
            return node;
        }
        for (PermissionNode child : node.children) {
            PermissionNode permNode = child.findPermissionNode(action);
            if (permNode == null) continue;
            return permNode;
        }
        return null;
    }
}

