/*
 * Decompiled with CFR 0.152.
 */
package ru.bgcrm.dao.process;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import org.bgerp.app.exception.BGException;
import ru.bgcrm.dao.CommonDAO;
import ru.bgcrm.model.process.queue.config.SavedCommonFiltersConfig;
import ru.bgcrm.model.process.queue.config.SavedFilter;

public class SavedFilterDAO
extends CommonDAO {
    public SavedFilterDAO(Connection con) {
        super(con);
    }

    public String getFilterUrlById(int id) {
        try {
            String query = "SELECT url FROM  process_common_filter  WHERE id=?";
            PreparedStatement ps = this.con.prepareStatement(query);
            ps.setInt(1, id);
            ResultSet rs = ps.executeQuery();
            if (rs.next()) {
                return rs.getString("url");
            }
            ps.close();
        }
        catch (SQLException e) {
            throw new BGException(e);
        }
        return "";
    }

    public ArrayList<SavedFilter> getFilters(int queueId) {
        try {
            String query = "SELECT * FROM  process_common_filter  WHERE queue_id = ?";
            PreparedStatement ps = this.con.prepareStatement(query);
            ps.setInt(1, queueId);
            ResultSet rs = ps.executeQuery();
            ArrayList<SavedFilter> commonFilters = new ArrayList<SavedFilter>();
            while (rs.next()) {
                commonFilters.add(new SavedFilter(rs.getInt("queue_id"), rs.getInt("id"), rs.getString("title"), rs.getString("url")));
            }
            ps.close();
            return commonFilters;
        }
        catch (SQLException e) {
            throw new BGException(e);
        }
    }

    public void deleteFilter(int id) throws SQLException {
        this.log.debug("Deleting " + id, new Object[0]);
        String query = "DELETE FROM  process_common_filter  WHERE id=?";
        PreparedStatement ps = this.con.prepareStatement(query);
        ps.setInt(1, id);
        ps.executeUpdate();
        ps.close();
    }

    public void updateFilter(SavedCommonFiltersConfig commonConfig, int queueId) throws SQLException {
        PreparedStatement ps = null;
        for (SavedFilter filter : commonConfig.getQueueSavedCommonFilterSetsMap(queueId)) {
            this.log.debug("params : " + filter.getTitle(), new Object[0]);
            String title = filter.getTitle();
            String url = filter.getUrl();
            int id = filter.getId();
            if (id >= 0) continue;
            ps = this.con.prepareStatement("INSERT INTO  process_common_filter  (queue_id, title, url) VALUES (?,?,?) ", 1);
            ps.setInt(1, queueId);
            ps.setString(2, title);
            ps.setString(3, url);
            ps.executeUpdate();
            filter.setId(this.lastInsertId(ps));
            ps.close();
        }
    }
}

