/*
 * Decompiled with CFR 0.152.
 */
package ru.bgcrm.plugin.bgbilling.proto.dao;

import java.util.ArrayList;
import java.util.List;
import org.bgerp.app.exception.BGException;
import org.bgerp.model.base.IdTitle;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import ru.bgcrm.model.user.User;
import ru.bgcrm.plugin.bgbilling.DBInfo;
import ru.bgcrm.plugin.bgbilling.Request;
import ru.bgcrm.plugin.bgbilling.dao.BillingDAO;
import ru.bgcrm.util.Utils;

public class ContractHierarchyDAO
extends BillingDAO {
    private static final String CONTRACT_MODULE_ID = "contract";
    private static final String CONTRACT_HIERARCHY_MODULE_ID = "contract.hierarchy";

    public ContractHierarchyDAO(User user, DBInfo dbInfo) throws BGException {
        super(user, dbInfo);
    }

    public ContractHierarchyDAO(User user, String billingId) throws BGException {
        super(user, billingId);
    }

    public List<Integer> getSubContracts(int contractId) throws BGException {
        Request request = new Request();
        request.setModule(CONTRACT_HIERARCHY_MODULE_ID);
        request.setAction("ContractInfo");
        request.setContractId(contractId);
        Document document = this.transferData.postData(request, this.user);
        Element contractElement = (Element)document.getElementsByTagName(CONTRACT_MODULE_ID).item(0);
        NodeList subContractElementList = contractElement.getElementsByTagName("sub");
        ArrayList<Integer> subContractList = new ArrayList<Integer>();
        for (int index = 0; index < subContractElementList.getLength(); ++index) {
            Element subContractElement = (Element)subContractElementList.item(index);
            subContractList.add(Utils.parseInt(subContractElement.getAttribute("id")));
        }
        return subContractList;
    }

    public void addSubcontract(int superContractId, int subContractId) throws BGException {
        Request req = new Request();
        req.setModule(CONTRACT_HIERARCHY_MODULE_ID);
        req.setAction("AddSub");
        req.setAttribute("super", superContractId);
        req.setAttribute("sub", subContractId);
        req.setAttribute("sub_mode", 0);
        this.transferData.postData(req, this.user);
    }

    public void addSubcontract(int superContractId, int subContractId, int subMode) throws BGException {
        Request req = new Request();
        req.setModule(CONTRACT_HIERARCHY_MODULE_ID);
        req.setAction("AddSub");
        req.setAttribute("super", superContractId);
        req.setAttribute("sub", subContractId);
        req.setAttribute("sub_mode", subMode);
        this.transferData.postData(req, this.user);
    }

    public List<IdTitle> contractSubcontractList(int contractId) throws BGException {
        Request request = new Request();
        request.setModule(CONTRACT_HIERARCHY_MODULE_ID);
        request.setAction("ContractInfo");
        request.setContractId(contractId);
        Document document = this.transferData.postData(request, this.user);
        Element dataElement = document.getDocumentElement();
        NodeList nodeList = dataElement.getElementsByTagName("sub");
        ArrayList<IdTitle> subContractList = new ArrayList<IdTitle>();
        for (int index = 0; index < nodeList.getLength(); ++index) {
            Element rowElement = (Element)nodeList.item(index);
            IdTitle subContract = new IdTitle();
            subContract.setId(Utils.parseInt(rowElement.getAttribute("id")));
            subContract.setTitle(rowElement.getAttribute("title"));
            subContractList.add(subContract);
        }
        return subContractList;
    }

    public IdTitle contractSupercontract(int contractId) throws BGException {
        Request request = new Request();
        request.setModule(CONTRACT_HIERARCHY_MODULE_ID);
        request.setAction("ContractInfo");
        request.setContractId(contractId);
        Document document = this.transferData.postData(request, this.user);
        Element dataElement = document.getDocumentElement();
        NodeList nodeList = dataElement.getElementsByTagName("super");
        if (nodeList.getLength() > 0) {
            IdTitle superContract = new IdTitle();
            Element rowElement = (Element)nodeList.item(0);
            superContract.setId(Utils.parseInt(rowElement.getAttribute("id")));
            superContract.setTitle(rowElement.getAttribute("title"));
            return superContract;
        }
        return null;
    }
}

