/*
 * Decompiled with CFR 0.152.
 */
package org.bgerp.model.base.tree;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.bgerp.util.Dynamic;

public abstract class TreeItem<T, C extends TreeItem<T, C>>
implements org.bgerp.model.base.tree.iface.TreeItem<T, C> {
    private static final String ICON_TAG_HOME = TreeItem.iconTag("ti-home");
    private static final String ICON_TAG_FOLDER = TreeItem.iconTag("ti-folder");
    private static final String ICON_TAG_FILE = TreeItem.iconTag("ti-file");
    protected T id;
    protected T parentId;
    protected String title;
    protected List<C> children = new ArrayList<C>();

    private static String iconTag(String icon) {
        return " <i class='" + icon + "'></i> ";
    }

    @Override
    public T getId() {
        return this.id;
    }

    public void setId(T id) {
        this.id = id;
    }

    @Override
    public T getParentId() {
        return this.parentId;
    }

    public void setParentId(T parentId) {
        this.parentId = parentId;
    }

    @Override
    public String getTitle() {
        return this.title;
    }

    public void setTitle(String value) {
        this.title = value;
    }

    @Override
    public List<C> getChildren() {
        return this.children;
    }

    public void setChildren(List<C> children) {
        this.children = children;
        if (children != null) {
            for (TreeItem child : children) {
                child.setParentId(this.id);
            }
        }
    }

    public C addChild(C child) {
        this.children.add(child);
        ((TreeItem)child).setParentId(this.id);
        return child;
    }

    public C getChild(T id) {
        return this.getChild(this, id);
    }

    private C getChild(TreeItem<T, C> root, T id) {
        for (TreeItem child : root.getChildren()) {
            if (id.equals(child.getId())) {
                return (C)child;
            }
            C ch = this.getChild(child, id);
            if (ch == null) continue;
            return ch;
        }
        return null;
    }

    public TreeItem<T, C> getById(T id) {
        if (this.id.equals(id)) {
            return this;
        }
        if (this.children != null) {
            return this.children.stream().filter(item -> item.getId().equals(id)).findFirst().orElse(null);
        }
        return null;
    }

    @Dynamic
    public int getChildCount() {
        return this.children.size();
    }

    public Set<T> getChildIds() {
        HashSet<T> ids = new HashSet<T>(100);
        for (TreeItem child : this.children) {
            ids.add(child.getId());
        }
        return ids;
    }

    public Set<T> getAllChildIds() {
        HashSet<T> result = new HashSet<T>(100);
        result.add(this.id);
        for (TreeItem childItem : this.children) {
            result.addAll(childItem.getAllChildIds());
        }
        return result;
    }

    @Dynamic
    public String getIcon() {
        if (this.children != null && !this.children.isEmpty()) {
            if (this.isRootNode()) {
                return ICON_TAG_HOME;
            }
            return ICON_TAG_FOLDER;
        }
        return ICON_TAG_FILE;
    }

    @Dynamic
    public String getTextStyle() {
        return null;
    }

    protected abstract boolean isRootNode();

    protected boolean isRootNodeWithIntegerId(Integer id, Integer parentId) {
        return id != null && id <= 0 && (parentId == null || parentId <= 0);
    }

    public boolean isInPathTo(Set<T> ids) {
        if (ids.contains(this.getId())) {
            return true;
        }
        for (TreeItem child : this.children) {
            if (!child.isInPathTo(ids)) continue;
            return true;
        }
        return false;
    }
}

